<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobJobSkillsTable extends Migration
{
    public function up()
    {
        Schema::create('job_job_skills', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('job_id')
                ->constrained('jobs')
                ->cascadeOnDelete();
            $table->foreignId('job_skill_id')
                ->constrained('job_skills')
                ->cascadeOnDelete();
        });
    }

    public function down()
    {
        Schema::dropIfExists('job_job_skills');
    }
}
