<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInquiriesTable extends Migration
{
    public function up()
    {
        Schema::create('inquiries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('uuid')->unique();
            $table->foreignId('contact_id')
                ->constrained('contacts')
                ->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()
                ->constrained('users')
                ->nullOnDelete();
            $table->text('form_data');
            $table->string('inquiry_status', 50)->default('pending');
            $table->string('inquiry_type', 50)->nullable();
            $table->string('inquiryable_type', 255)->nullable();
            $table->unsignedBigInteger('inquiryable_id')->nullable();
            $table->timestamp('created_at');

            $table->index('inquiry_status');
            $table->index('inquiry_type');
            $table->index('inquiryable_type');
            $table->index('inquiryable_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('inquiries');
    }
}
