<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\PageStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('heading', 191)->nullable();
            $table->string('slug')->unique();
            $table->longText('content')->nullable();
            $table->longText('data')->nullable();
            $table->string('page_type', 191)->default('page');
            $table->string('route_name', 191)->nullable()->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('pages')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('expired_at')->nullable();
            $table->string('status')->default(PageStatus::Draft->value);
            $table->string('template', 255)->nullable();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->cascadeOnUpdate();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
