<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('lead_form_member_category', function (Blueprint $table) {
            $table->integer('credits')->default(0)->after('lead_form_id');
            $table->dropColumn('price');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('lead_form_member_category', function (Blueprint $table) {
            $table->dropColumn('credits');
            $table->decimal('price', 10, 2)->nullable()->after('lead_form_id');
        });
    }
};
