<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('field_lead_form', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lead_form_id')
                ->constrained('lead_forms')
                ->cascadeOnDelete();
            $table->foreignId('field_id')
                ->constrained('lead_form_fields')
                ->cascadeOnDelete();
            $table->string('field_placeholder', 191)
                ->nullable();
            $table->string('toggle_yes_text', 50)
                ->nullable();
            $table->string('toggle_no_text', 50)
                ->nullable();
            $table->integer('field_columns')
                ->nullable()
                ->default(1);
            $table->text('help_text')
                ->nullable();
            $table->text('field_options')
                ->nullable();
            $table->boolean('is_required')
                ->default(false);
            $table->boolean('is_visible')
                ->default(true);
            $table->integer('field_order')
                ->default(0);
            $table->timestamps();
        });

        Schema::table('lead_form_fields', function (Blueprint $table) {

            $table->boolean('is_default')
                ->after('data_type')
                ->default(false);
            $table->dropForeign(['lead_form_id']);
            $table->dropColumn('lead_form_id');
            $table->dropColumn('field_placeholder');
            $table->dropColumn('toggle_yes_text');
            $table->dropColumn('toggle_no_text');
            $table->dropColumn('field_columns');
            $table->dropColumn('help_text');
            $table->dropColumn('field_options');
            $table->dropColumn('is_required');
            $table->dropColumn('is_visible');
            $table->dropColumn('field_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('lead_form_fields', function (Blueprint $table) {
            $table->foreignId('lead_form_id')
                ->after('uuid')
                ->nullable()
                ->constrained('lead_forms')
                ->nullOnDelete();
            $table->string('field_placeholder', 191)
                ->nullable();
            $table->string('toggle_yes_text', 50)
                ->nullable();
            $table->string('toggle_no_text', 50)
                ->nullable();
            $table->integer('field_columns')
                ->nullable();
            $table->text('help_text')
                ->nullable();
            $table->text('field_options')
                ->nullable();
            $table->boolean('is_required')
                ->default(false);
            $table->boolean('is_visible')
                ->default(true);
            $table->integer('field_order')
                ->default(0);
        });

        Schema::dropIfExists('field_lead_form');
    }
};
