<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_profiles', function (Blueprint $table) {
            $table->string('mobile')->after('phone')->nullable();
        });

        Schema::create('user_profiles_meta', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('user_profile_id')
                ->constrained('user_profiles')
                ->cascadeOnDelete()
                ->noActionOnUpdate();
            $table->string('type', 45);
            $table->string('key', 255);
            $table->text('value')->nullable();
            $table->timestamps();
            $table->index('key');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_profiles_meta');

        Schema::table('user_profiles', function (Blueprint $table) {
            $table->dropColumn('mobile');
        });
    }
};
