<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\ProjectCompletedStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->string('completed_status')
                ->after('outcomes')
                ->default(ProjectCompletedStatus::InProgress->value);
            $table->date('completion_date')
                ->after('completed_status')
                ->nullable();
            $table->decimal('project_cost', 10, 2)
                ->after('completion_date')
                ->nullable();
            $table->text('tags')
                ->after('project_cost')
                ->nullable();
            $table->text('metrics')
                ->after('tags')
                ->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn('completed_status');
            $table->dropColumn('completion_date');
            $table->dropColumn('project_cost');
            $table->dropColumn('tags');
            $table->dropColumn('metrics');
        });
    }
};
