<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

use function Livewire\after;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('classifieds', function (Blueprint $table) {
            $table->decimal('discount_price', 10, 2)
            ->after('price')
            ->nullable()
            ->default(0.00);
            $table->text('key_features')
            ->after('is_featured')
            ->nullable();
            $table->text('maintenance_detail')
            ->after('key_features')
            ->nullable();
            $table->string('condition')
                ->after('maintenance_detail')
                ->nullable()
                ->default('used');
            $table->string('label')
                ->after('condition')
                ->nullable()
                ->default('for-sale');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('classifieds', function (Blueprint $table) {
            $table->dropColumn('discount_price');
            $table->dropColumn('key_features');
            $table->dropColumn('maintenance_detail');
        });
    }
};
