<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\EquipmentStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equipment_categories', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')
                ->unique();
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('equipment_categories')
                ->nullOnDelete();
            $table->string('category_name', 255);
            $table->string('slug', 255)
                ->unique();
            $table->text('category_description')
                ->nullable();
            $table->boolean('is_active')
                ->default(1);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();
            $table->timestamps();
        });

        Schema::create('equipments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')
                ->unique();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->string('title', 255);
            $table->string('slug', 255)
                ->unique();
            $table->text('address')
                ->nullable();
            $table->foreignId('city_id')
                ->nullable()
                ->constrained('cities')
                ->nullOnDelete();
            $table->foreignId('state_id')
                ->nullable()
                ->constrained('states')
                ->nullOnDelete();
            $table->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->nullOnDelete();
            $table->text('specification')
                ->nullable();
            $table->text('description')
                ->nullable();
            $table->text('use_case')
                ->nullable();
            $table->text('constraint')
                ->nullable();
            $table->text('tags')
                ->nullable();
            $table->string('status')
                ->default(EquipmentStatus::Draft->value);
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('equipment_equipment_category', function (Blueprint $table) {
            $table->id();
            $table->foreignId('equipment_id')
                ->constrained('equipments')
                ->cascadeOnDelete();
            $table->foreignId('equipment_category_id')
                ->constrained('equipment_categories')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipment_equipment_category');
        Schema::dropIfExists('equipments');
        Schema::dropIfExists('equipment_categories');
    }
};
