<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('review_ratings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('review_id')
                ->constrained('reviews')
                ->cascadeOnDelete();
            $table->string('rating_type');
            $table->float('rating')->default(0);
            $table->timestamps();
        });

        Schema::table('reviews', function (Blueprint $table) {
            $table->float('review_rating')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('review_ratings');

        Schema::table('reviews', function (Blueprint $table) {
            $table->integer('review_rating')->default(0)->change();
        });
    }
};
