<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('classified_deliveries', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->string('name', 255);
            $table->string('slug', 255)->unique();
            $table->string('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('classified_deliveries')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete()
                ->noActionOnUpdate();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('classified_classified_delivery', function (Blueprint $table) {
            $table->id();
            $table->foreignId('classified_id')
                ->constrained('classifieds')
                ->cascadeOnDelete();
            $table->foreignId('classified_delivery_id')
                ->constrained('classified_deliveries')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('classified_classified_delivery');
        Schema::dropIfExists('classified_deliveries');
    }
};
