<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_videos', function (Blueprint $table) {
            $table->unsignedBigInteger('views')->default(0)->after('video_link');
            $table->integer('likes')->default(0)->after('views');
            $table->boolean('is_featured')->default(false)->after('likes');
            $table->text('tags')->nullable()->after('is_featured');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_videos', function (Blueprint $table) {
            $table->dropColumn('views');
            $table->dropColumn('likes');
            $table->dropColumn('is_featured');
            $table->dropColumn('tags');
        });
    }
};
