<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\PaymentStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            $table->string('currency', 10)->after('amount')->nullable()->default('USD');
            $table->integer('quantity')->after('currency')->nullable()->default(1);
            $table->decimal('total_amount', 10, 2)->after('quantity')->nullable()->default(0.00);
            $table->decimal('discount_amount', 10, 2)->after('total_amount')->nullable()->default(0.00);
            $table->decimal('tax_amount', 10, 2)->after('discount_amount')->nullable()->default(0.00);
            $table->text('notes')->after('tax_amount')->nullable();
            $table->string('purchase_date')->after('notes')->nullable();
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->string('status', 10)->after('purchase_id')->nullable()->default(PaymentStatus::Paid->value);
            $table->string('payment_date')->after('status')->nullable();
            $table->string('currency', 10)->after('payment_date')->nullable()->default('USD');
            $table->text('notes')->after('currency')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchases', function (Blueprint $table) {
            $table->dropColumn('currency');
            $table->dropColumn('quantity');
            $table->dropColumn('total_amount');
            $table->dropColumn('discount_amount');
            $table->dropColumn('tax_amount');
            $table->dropColumn('notes');
            $table->dropColumn('purchase_date');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('payment_date');
            $table->dropColumn('currency');
            $table->dropColumn('notes');
        });
    }
};
