<?php

use App\Enums\SubscriptionStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('status')->after('cancelled_at')->default(SubscriptionStatus::Active->value);
            $table->string('type')->after('status')->nullable();
            $table->string('stripe_id')->after('type')->unique()->nullable();
            $table->string('stripe_status')->after('stripe_id')->nullable();
            $table->string('stripe_price')->after('stripe_status')->nullable();
            $table->integer('quantity')->after('stripe_price')->nullable();
            // $table->timestamp('trial_ends_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            $table->index(['user_id', 'stripe_status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Drop columns (the index will be automatically dropped when stripe_status is dropped)
            $table->dropColumn([
                'status',
                'type',
                'stripe_status',
                'stripe_price',
                'quantity',
                'ends_at',
            ]);
        });

        // Drop unique constraint and column separately
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropUnique(['stripe_id']);
            $table->dropColumn('stripe_id');
        });
    }
};
