<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->text('location')->nullable()->after('address');
            $table->foreignId('city_id')
                ->nullable()
                ->after('location')
                ->constrained('cities')
                ->nullOnDelete();
            $table->foreignId('state_id')
                ->nullable()
                ->after('city_id')
                ->constrained('states')
                ->nullOnDelete();
            $table->foreignId('country_id')
                ->nullable()
                ->after('state_id')
                ->constrained('countries')
                ->nullOnDelete();
            $table->string('postal_code', 100)->nullable()->after('country_id');
            $table->string('latitude', 100)->nullable()->after('postal_code');
            $table->string('longitude', 100)->nullable()->after('latitude');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
