<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFormLayoutAndFieldDataToLeadFormTables extends Migration
{
    public function up()
    {
        Schema::table('lead_forms', function (Blueprint $table) {
            $table->string('form_layout', 100)
                ->nullable()
                ->after('submit_message');
            $table->text('form_steps')
                ->nullable()
                ->after('form_layout');
        });

        Schema::table('field_lead_form', function (Blueprint $table) {
            // Ensure uuid exists for models using HasUuidTrait
            if (! Schema::hasColumn('field_lead_form', 'uuid')) {
                $table->uuid('uuid')
                    ->nullable()
                    ->unique()
                    ->after('id');
            }
            $table->string('field_label', 191)
                ->nullable()
                ->after('field_id');
            $table->text('field_data')
                ->nullable()
                ->after('field_options');
            $table->text('form_step')
                ->nullable()
                ->after('field_data');
        });
    }

    public function down()
    {
        Schema::table('lead_forms', function (Blueprint $table) {
            $table->dropColumn('form_layout');
            $table->dropColumn('form_steps');
        });

        Schema::table('field_lead_form', function (Blueprint $table) {
            $table->dropColumn('field_data');
            $table->dropColumn('form_step');
            $table->dropColumn('field_label');
            if (Schema::hasColumn('field_lead_form', 'uuid')) {
                $table->dropColumn('uuid');
            }
        });
    }
}
