<?php

namespace Database\Seeders;

use App\Models\Blog\Post;
use App\Models\Blog\PostCategory;
use App\Models\Blog\PostTag;
use App\Models\Seo;
use App\Models\User\User;
use Illuminate\Database\Seeder;

class BlogPostSeeder extends Seeder
{
    public function run(): void
    {
        // Get existing records
        $authors = User::all();
        $categories = PostCategory::all();
        $tags = PostTag::all();

        // Ensure we have records to work with
        if ($authors->isEmpty() || $categories->isEmpty() || $tags->isEmpty()) {
            throw new \Exception('Please run JobCategorySeeder first to create required records');
        }

        // Create posts and attach random categories and tags to each
        Post::factory()
            ->count(100)
            ->sequence(fn ($sequence) => [
                'created_by' => $authors->random()->id,
            ])
            ->create()
            ->each(function ($post) use ($categories, $tags) {
                // Attach 1-2 random categories to each post
                $post->categories()->attach(
                    $categories->random(rand(1, 2))->pluck('id')->toArray()
                );

                // Attach 2-5 random tags to each post
                $post->tags()->attach(
                    $tags->random(rand(2, 5))->pluck('id')->toArray()
                );

                // Create SEO record for the post
                $post->seo()->create([
                    'title' => fake()->sentence(6),
                    'description' => fake()->paragraph(2),
                ]);
            });
    }
}
