<?php

namespace Database\Seeders;

use App\Models\Location\City;
use App\Models\Location\Country;
use App\Models\Location\State;
use App\Models\User\User;
use Illuminate\Database\Seeder;

class CanadaLocationSeeder extends Seeder
{
    public function run(): void
    {
        // Create a user for locations
        $admin = User::firstOrCreate(
            ['email' => 'admin@admin.com'],
            [
                'name' => 'Admin User',
                'password' => bcrypt('admin123'),
            ]
        );
        // Assign Super Admin role to the admin user
        $admin->assignRole('Super Admin');
        // Create Canada
        $canada = Country::factory()
            ->state(['created_by' => $admin->id])
            ->create();

        // Create all provinces and territories
        $provinces = [
            'AB',
            'BC',
            'MB',
            'NB',
            'NL',
            'NS',
            'NT',
            'NU',
            'ON',
            'PE',
            'QC',
            'SK',
            'YT'
        ];

        foreach ($provinces as $provinceCode) {
            $province = State::factory()
                ->state([
                    'country_id' => $canada->id,
                    'created_by' => $admin->id
                ])
                ->create();

            // Create cities for this province
            City::factory()
                ->count(5)  // Create 5 cities per province
                ->forProvince($provinceCode)
                ->state([
                    'state_id' => $province->id,
                    'country_id' => $canada->id,
                    'created_by' => $admin->id
                ])
                ->create();
        }
    }
}
