<?php

namespace Database\Seeders;

use App\Models\Currency;
use App\Models\User\User;
use Database\Factories\CurrencyFactory;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        // Get or create an admin user for created_by
        $admin = User::firstOrCreate(
            ['email' => 'admin@admin.com'],
            [
                'name' => 'Admin User',
                'password' => bcrypt('admin123'),
            ]
        );

        // Create all currencies from factory
        collect(CurrencyFactory::$currencies)->each(function ($currency) use ($admin) {
            Currency::factory()->state([
                'currency_name' => $currency['name'],
                'currency_code' => $currency['code'],
                'currency_symbol' => $currency['symbol'],
                'currency_rate' => $currency['rate'],
                'is_default' => $currency['code'] === 'USD',
                'is_active' => true,
                'created_by' => $admin->id
            ])->create();
        });
    }
} 