<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Equipment\Equipment;
use App\Models\User\User;
use App\Models\Equipment\EquipmentCategory;
use App\Models\Location\City;
use App\Models\Location\State;
use App\Models\Location\Country;

class EquipmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $authors = User::all();
        $categories = EquipmentCategory::all();
        $cities = City::all();
        $states = State::all();
        $countries = Country::all();

        Equipment::factory()->count(50)
            ->sequence(fn($sequence) => [
                'created_by' => $authors->random()->id
            ])
            ->create()
            ->each(function ($equipment) use ($categories, $cities, $states, $countries) {
                // Assign location data
                $equipment->city_id = $cities->random()->id;
                $equipment->state_id = $states->random()->id;
                $equipment->country_id = $countries->random()->id;
                $equipment->save();
                // Assign 1-3 random categories to each equipment
                $randomCategories = $categories->random(rand(1, 3));
                $equipment->categories()->attach($randomCategories->pluck('id')->toArray());
            });
    }
}
