<?php

namespace Database\Seeders;

use App\Models\User\User;
use App\Models\Blog\PostCategory;
use App\Models\Blog\PostTag;
use App\Models\Classified\ClassifiedType;
use App\Models\Classified\ClassifiedCategory;
use App\Models\Classified\ClassifiedTag;
use App\Models\Classified\ClassifiedDelivery;
use Illuminate\Database\Seeder;
use App\Models\Job\JobRole;
use App\Models\Job\JobIndustry;
use App\Models\Job\JobSkill;
use App\Models\Job\JobType;
use App\Models\Job\JobCareerLevel;

class JobCategorySeeder extends Seeder
{
    public function run(): void
    {
        $admin = User::firstOrCreate(
            ['email' => 'admin@admin.com'],
            [
                'name' => 'Admin User',
                'password' => bcrypt('admin123'),
            ]
        );
        // Create additional authors (users) for blog
        $authors = collect([$admin]);

        // Create blog categories
        PostCategory::factory()
            ->state(['created_by' => $authors->random()->id])
            ->count(102)
            ->create();

        // Create blog tags
        PostTag::factory()
            ->state(['created_by' => $authors->random()->id])
            ->count(500)
            ->create();

        // Create classified types
        ClassifiedType::factory()
            ->count(150)
            ->state(['created_by' => $authors->random()->id])
            ->create();

        // Create classified categories
        ClassifiedCategory::factory()
            ->count(89)
            ->state(['created_by' => $authors->random()->id])
            ->create();

        // Create classified tags
        ClassifiedTag::factory()
            ->count(700)
            ->state(['created_by' => $authors->random()->id])
            ->create();

        // Create classified deliveries
        ClassifiedDelivery::factory()
            ->count(50)
            ->state(['created_by' => $authors->random()->id])
            ->create();

        // Predefined job categories
        $categories = [
            'roles' => ['Software Engineer', 'Product Manager', 'Data Scientist', 'UX Designer'],
            'industries' => ['Technology', 'Healthcare', 'Finance', 'Education'],
            'skills' => ['PHP', 'JavaScript', 'Python', 'SQL', 'AWS'],
            'types' => ['Full-time', 'Part-time', 'Contract', 'Remote'],
            'levels' => ['Entry Level', 'Mid Level', 'Senior', 'Lead', 'Executive'],
        ];

        // Insert job categories
        foreach ($categories['roles'] as $role) {
            JobRole::create(['job_role_name' => $role, 'created_by' => $admin->id]);
        }
        foreach ($categories['industries'] as $industry) {
            JobIndustry::create(['industry_name' => $industry, 'created_by' => $admin->id]);
        }
        foreach ($categories['skills'] as $skill) {
            JobSkill::create(['job_skill_name' => $skill, 'created_by' => $admin->id]);
        }
        foreach ($categories['types'] as $type) {
            JobType::create(['job_type_name' => $type, 'created_by' => $admin->id]);
        }
        foreach ($categories['levels'] as $level) {
            JobCareerLevel::create(['career_level_name' => $level, 'created_by' => $admin->id]);
        }
    }
}
