<?php

namespace Database\Seeders;

use App\Models\Job\Job;
use App\Models\Job\JobApplication;
use App\Models\User\User;
use Illuminate\Database\Seeder;

class JobSeeder extends Seeder
{
    public function run(): void
    {
        // Create 100 new jobs
        for ($i = 0; $i < 100; $i++) {
            $job = Job::factory()
                ->withSkills(rand(3, 5))
                ->create();

            // Create 0-3 job applications for this job immediately
            $numberOfApplications = rand(0, 3);
            for ($j = 0; $j < $numberOfApplications; $j++) {
                $applicant = User::inRandomOrder()->first();

                JobApplication::factory()->create([
                    'job_id' => $job->id,
                    'applicant_id' => $applicant->id,
                ]);
            }
        }
    }
}
