<?php

namespace Database\Seeders;

use App\Enums\LeadFormFieldDataType;
use App\Enums\LeadFormFieldType;
use App\Models\Lead\LeadFormFields;
use Illuminate\Database\Seeder;

class LeadFormFieldSeeder extends Seeder
{
    public function run(): void
    {
        $defaultFields = [
            [
                'field_name' => 'First Name',
                'field_id' => 'first_name',
                'field_type' => LeadFormFieldType::Text->value,
                'data_type' => LeadFormFieldDataType::AlphaNumeric->value,
                'is_default' => true,
            ],
            [
                'field_name' => 'Last Name',
                'field_id' => 'last_name',
                'field_type' => LeadFormFieldType::Text->value,
                'data_type' => LeadFormFieldDataType::AlphaNumeric->value,
                'is_default' => true,
            ],
            [
                'field_name' => 'Email',
                'field_id' => 'email',
                'field_type' => LeadFormFieldType::Text->value,
                'data_type' => LeadFormFieldDataType::Email->value,
                'is_default' => true,
            ],
            [
                'field_name' => 'Phone',
                'field_id' => 'phone',
                'field_type' => LeadFormFieldType::Text->value,
                'data_type' => LeadFormFieldDataType::Phone->value,
                'is_default' => true,
            ],
        ];

        foreach ($defaultFields as $field) {
            LeadFormFields::create($field);
        }
    }
}
