document.addEventListener("DOMContentLoaded", function () {
  document
    .querySelector(".collapse-btn")
    .addEventListener("click", function () {
      document.querySelector(".sidebar").classList.toggle("active");
      document.querySelector(".right-content").classList.toggle("active");
    });
});

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("service-input");
  const tagsContainer = document.querySelector(".tags-container");

  input.addEventListener("keypress", (e) => {
    if (e.key === "Enter" && input.value.trim() !== "") {
      addTag(input.value.trim());
      input.value = ""; // Clear input field
    }
  });

  const addTag = (text) => {
    const tag = document.createElement("div");
    tag.className = "tag";
    tag.innerHTML = `${text} <span class="remove"> <img src="images/crose-icon.png" alt="" /></span>`;
    tagsContainer.appendChild(tag);

    tag.querySelector(".remove").addEventListener("click", () => {
      tag.remove(); // Remove tag on 'x' click
    });
  };
});

 // Initialize Quill.js editor
 const quill = new Quill("#editor-container", {
  theme: "snow", // Use 'snow' theme for the toolbar
  placeholder: "",
  modules: {
    toolbar: [
      [{ header: [1, 2, 3, false] }],
      ["bold", "italic", "underline"],
      ["link", "blockquote", "code-block"],
      [{ list: "ordered" }, { list: "bullet" }],
      [{ script: "sub" }, { script: "super" }],
      [{ color: [] }, { background: [] }],
      ["clean"], // Remove formatting button
    ],
  },
});