# ESP Lead Form Embed SDK

A lightweight JavaScript SDK for embedding ESP lead forms on external websites.

## 🚀 Quick Start

**First time setup? Start here:**

1. **Open the diagnostic page**: `http://esp_directory.test/js/sdk/test.html`
2. Follow the instructions to get your API credentials
3. Test your connection
4. View your form in the demo page

**Full setup guide**: [SETUP.md](./SETUP.md)

---

## Files

- **embedForms.js** - Main SDK JavaScript (vanilla JS, no dependencies)
- **embedForms.css** - Minimal styling with CSS custom properties
- **test.html** - 🔧 **API Diagnostics & Testing Tool** (Start here!)
- **demo.html** - Interactive demo page with example styling
- **SETUP.md** - Complete setup instructions
- **README.md** - This file

---

## Usage

### 1. Include SDK Files

```html
<link rel="stylesheet" href="https://yourdomain.com/js/sdk/embedForms.css">
<script src="https://yourdomain.com/js/sdk/embedForms.js"></script>
```

### 2. Add Form Container

```html
<div class="esp-lead-form"
     data-form-id="your-form-uuid"
     data-api-token="your-bearer-token"
     data-api-url="https://yourdomain.com">
</div>
```

---

## Getting Credentials

### Method 1: Admin Panel
1. Go to `http://esp_directory.test/espadmin`
2. Navigate to **API Clients** → Create new client
3. Copy the Bearer Token
4. Go to **Lead Forms** → Copy form UUID

### Method 2: Test Page
1. Open `http://esp_directory.test/js/sdk/test.html`
2. Follow the on-screen instructions

See [SETUP.md](./SETUP.md) for detailed instructions.

---

## Documentation

For complete documentation, examples, and troubleshooting, see:

**[docs/api/javascript-sdk.md](../../../docs/api/javascript-sdk.md)**

## Features

- All field types supported (text, email, select, checkbox, radio, toggle, file, geolocation, etc.)
- Client-side and server-side validation
- Visit tracking
- Responsive grid layout
- Theme customization via CSS variables
- Zero dependencies

## Browser Support

- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## Requirements

- Laravel Sanctum Bearer token
- Active lead form in ESP Directory
- CORS enabled for your domain

## Demo

Open `demo.html` in your browser after configuring your form UUID and API token.

## Support

For issues or questions, contact: support@espdirectory.com
