/** @type {import('tailwindcss').Config} */
import preset from './../../../vendor/filament/support/tailwind.config.preset'
import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
const colors = require('tailwindcss/colors')
 
module.exports = {
    presets: [preset],
    content: [
        "./resources/**/*.blade.php", // Laravel Blade templates
        "./resources/**/*.js", // JavaScript files
        "./resources/**/*.vue", // Vue.js files (agar use kar rahe hain)
        "./public/**/*.{html,js}", // Static files
        "./node_modules/flowbite/**/*.js", // Flowbite plugin
        './app/Filament/**/*.php',
        './resources/views/filament/**/*.blade.php',
        './vendor/filament/**/*.blade.php',
    ],
    theme: {
        extend: {
            colors: {
                "body-blue": "#EEF8FA",
                "dark-blue": "#0F1729",
                "blue-1200": "#0172B1",
                "blue-1300": "#8280FF",
                "blue-1400": "#F5F7FA",
                "red-1200": "#C9020E",
                "red-1300": "#D32F2F",
                "red-1400": "#EF3826",
                "red-1500": "#FD5454",
                "light-red-1200": "#FFEFEF",
                "black-1200": "#202224",
                "black-1300": "#020202",
                "black-1400": "#404B52",
                "gray-1200": "#DBDBDB",
                "gray-1300": "#EEEEEE",
                "gray-1400": "#F5F5F5",
                "gray-1500": "#636363",
                "orange-bg-1200": "#FEC53D",
                "orange-bg-1200": "#FEC53D",
                "orange-bg-1400": "#FE8F3E",
                "green-1200": "#4CAF50",
                "green-1300": "#00B69B",
                "green-1400": "#40C979",
                "yellow-1200": "#FFC107",
                "purpal-1200": "#BA29FF",
            },
            fontFamily: {
                Poppins: ["Poppins", "sans-serif"],
            },
            height: {
                41: "41px",
                small4: "4.88px",
                266: "266px",
            },
            width: {
                41: "41px",
                small4: "4.88px",
            },
            padding: {
                21: "21px",
                60: "60px",
                70: "70px",
            },
            letterSpacing: {
                default: "0.26px",
                0.7: "0.27px",
                0.3: "0.3px",
                0.24: "0.24px",
                1: "1px",
                0.06: "-0.06px",
                "32p": "0.32px",
                39: "0.39px",
            },
            maxWidth: {
                "11xl": "249px",
            },
            brightness: {
                180: "18605%",
            },
            boxShadow: {
                "3xl": "6px 6px 54px 0px rgba(0,0,0,0.05)",
                "4xl": "0px 20px 50px 0px rgba(55,69,87,0.1)",
                "5xl": "0px 6px 20px 0px rgba(0,0,0,0.20)",
                "6xl": "6px 6px 54px 0px rgba(0,0,0,0.35)",
                "7xl": "0px 0px 20.3px 0px rgba(1,114,177,0.15)",
            },
            borderRadius: {
                14: "14px",
            },
            fontSize: {
                22: "22px",
            },
            margin: {
                28: "28px",
            },
            screens: {
                sm: "576px",
                md: "768px",
                lg: "992px",
                xl: "1200px",
                "2xl": "1366px",
            },
        },
    },
    plugins: [
        forms,
        require('@tailwindcss/forms'),
        require('@tailwindcss/typography'),
        require("flowbite/plugin")
    ],
};
 
 