const colors = require("tailwindcss/colors");
import preset from "../../../vendor/filament/filament/tailwind.config.preset";

module.exports = {
    presets: [preset],
    theme: {
        extend: {
            fontFamily: {
                // sans: ['Inter var', ...defaultTheme.fontFamily.sans],
            },
        },
        colors: {
            "dark-blue": "#0F1729",
            "dark-blue-1200": "#3B5A98",
            "light-blue": "#0172B1",
            "light-blue-1200": "#2AA0F2",
            "light-blue-1300": "#1D77B6",
            "red-bg": "#C9020E",
            "red-1200": "#EA4235",
            "black-1200": "#030303",
            "black-1300": "#2D2E2E",
            "black-1400": "#003350",
            "dark-gray-1200": "#AAAAAA",
        },
        boxShadow: {
            "3xl": "0 10px 37.4px 0px rgba(15,23,41,0.06)",
            "4xl": "4px 4px 42.5px 0px rgba(1,114,117,0.08)",
            "5xl": "0 2px 24px 0px rgba(234,66,53,0.25)",
            "6xl": "0 2px 24px 0px rgba(42,160,242,0.25)",
            "7xl": "0 2px 24px 0px rgba(50,90,152,0.25)",
            "8xl": "0 2px 24px 0px rgba(29,119,182,0.25)",
            "9xl": "4px 4px 42.5px rgba(1, 114, 177, 0.08)",
        },
    },
    variants: {
        extend: {
            backgroundColor: ["active"],
        },
    },
    content: [
        "./resources/**/*.php",
        "./app/Filament/**/*.php",
        "./resources/views/filament/**/*.blade.php",
        "./vendor/filament/**/*.blade.php",
        "./resources/**/*.js",
        "./node_modules/flowbite/**/*.js",
        "./vendor/awcodes/filament-tiptap-editor/resources/**/*.blade.php",
    ],
    plugins: [
        require("@tailwindcss/forms"),
        require("@tailwindcss/typography"),
        require("flowbite/plugin"),
    ],
};
