// Function to initialize all event listeners
function initializeEventListeners() {
    // Initialize Flowbite dropdowns
    initFlowbite();

    // Collapse button event listener
    // const collapseBtn = document.querySelector(".collapse-btn");
    // if (collapseBtn) {
    //     collapseBtn.addEventListener("click", function () {
    //         document.querySelector(".sidebar").classList.toggle("active");
    //         document.querySelector(".right-content").classList.toggle("active");
    //     });
    // }

    // Menu button event listener
    const menuBtn = document.querySelector(".menu-btn");
    if (menuBtn) {
        menuBtn.addEventListener("click", function () {
            document.querySelector(".sidebar").classList.toggle("show");
        });
    }

    // Search button event listener
    const searchBtn = document.querySelector(".search-btn");
    if (searchBtn) {
        searchBtn.addEventListener("click", function () {
            var searchBox = document.querySelector(".search-box");
            if (searchBox.style.display === "none" || searchBox.style.display === "") {
                searchBox.style.display = "block";
            } else {
                searchBox.style.display = "none";
            }
        });
    }

    // Service input tag functionality
    const input = document.getElementById("service-input");
    const tagsContainer = document.querySelector(".tags-container");

    if (input && tagsContainer) {
        input.addEventListener("keydown", (e) => {
            if (e.key === "Enter" && input.value.trim() !== "") {
                addTag(input.value.trim());
                input.value = "";
            }
        });
    }
}

// Function to add tags
function addTag(text) {
    const tagsContainer = document.querySelector(".tags-container");
    if (!tagsContainer) return;

    const tag = document.createElement("div");
    tag.className = "tag";
    tag.innerHTML = `
        ${text} 
        <span class="remove">
            <img src="images/crose-icon.png" alt="" />
        </span>
    `;

    tagsContainer.appendChild(tag);

    tag.querySelector(".remove").addEventListener("click", () => {
        tag.remove();
    });
}

// Function to remove items
function removeItem(element) {
    const itemDiv = element.parentElement;
    itemDiv.remove();
}

// Initialize on first load
document.addEventListener("DOMContentLoaded", initializeEventListeners);

// Initialize on Livewire navigation
document.addEventListener("livewire:navigated", initializeEventListeners);

// Clean up event listeners before navigation
document.addEventListener("livewire:navigating", () => {
    // Clean up any existing collapse instances
    const collapseElements = document.querySelectorAll('[data-collapse-toggle]');
    collapseElements.forEach(el => {
        const targetId = el.getAttribute('data-collapse-toggle');
        const target = document.getElementById(targetId);
        if (target) {
            // Remove any existing event listeners
            const clone = el.cloneNode(true);
            el.parentNode.replaceChild(clone, el);
        }
    });
});