<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Laravel') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
</head>
<body>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Livewire.dispatch('openModal', {
                component: 'frontend.auth.modal.password-reset-modal',
                arguments: {
                    token: '{{ $token }}',
                    email: '{{ $email }}'
                }
            });
        });
    </script>
    @livewireScripts
</body>
</html>
