@props(['user', 'activeSubscription'])

<div class="col-span-12 lg:col-span-3">
    <div class="flex flex-col items-center rounded-xl bg-white p-6 shadow-sm">
        <div class="relative mb-4">
            @if($user->getFirstMedia('avatar'))
                <img src="{{ $user->getFirstMedia('avatar')->getUrl() }}" 
                     alt="{{ $user->name }}" 
                     class="h-48 w-48 rounded-full object-cover ring-4 ring-gray-50" />
            @else
                <div class="flex h-48 w-48 items-center justify-center rounded-full bg-primary-50">
                    <x-heroicon-o-user-circle class="h-32 w-32 text-primary-200" />
                </div>
            @endif
            <div class="absolute -bottom-2 right-2">
                <div class="rounded-full bg-success-500 p-2">
                    <x-heroicon-m-check class="h-4 w-4 text-white"/>
                </div>
            </div>
        </div>
        
        <h2 class="text-xl font-bold text-gray-900">{{ $user->name }}</h2>
        @if($user->profile?->company_name)
            <p class="mt-1 text-sm font-medium text-gray-500">{{ $user->profile->company_name }}</p>
        @endif
        
        <div class="mt-4 flex items-center gap-2 text-sm text-gray-500">
            <x-heroicon-m-calendar class="h-4 w-4"/>
            {{ __("Joined") }} {{ $user->created_at->format('M d, Y') }}
        </div>
        
        @if($activeSubscription)
            <div class="mt-3 inline-flex items-center rounded-full bg-primary-50 px-3 py-1 text-sm font-medium text-primary-700">
                <x-heroicon-m-star class="mr-1.5 h-4 w-4"/>
                {{ $activeSubscription->membershipPlan->package_title }}
            </div>
        @endif

        @if($user->profile?->slogan)
            <p class="mt-3 text-sm text-gray-600 text-center italic">
                "{{ $user->profile->slogan }}"
            </p>
        @endif

        {{-- Stats Grid --}}
        <div class="mt-6 w-full">
            <div class="grid grid-cols-2 gap-3">
                {{-- Views --}}
                <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-blue-50 to-blue-100/50 p-4 transition hover:shadow-md">
                    <div class="relative z-10 flex flex-col items-center justify-center">
                        <div class="text-2xl font-bold text-blue-900">{{ number_format($user->profile_views ?? 0) }}</div>
                        <div class="text-xs font-medium text-blue-600">{{ __("Total Views") }}</div>
                    </div>
                    <div class="absolute -right-6 -top-6 h-16 w-16 rounded-full bg-blue-100/50 transition group-hover:scale-150"></div>
                    <div class="absolute -bottom-6 -left-6 h-16 w-16 rounded-full bg-blue-100/50 transition group-hover:scale-150"></div>
                </div>

                {{-- Leads --}}
                <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-primary-50 to-primary-100/50 p-4 transition hover:shadow-md">
                    <div class="relative z-10 flex flex-col items-center justify-center">
                        <div class="text-2xl font-bold text-primary-900">{{ number_format($user->leads->count() ?? 0) }}</div>
                        <div class="text-xs font-medium text-primary-600">{{ __("Total Leads") }}</div>
                    </div>
                    <div class="absolute -right-6 -top-6 h-16 w-16 rounded-full bg-primary-100/50 transition group-hover:scale-150"></div>
                    <div class="absolute -bottom-6 -left-6 h-16 w-16 rounded-full bg-primary-100/50 transition group-hover:scale-150"></div>
                </div>

                {{-- Reviews --}}
                <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-indigo-50 to-indigo-100/50 p-4 transition hover:shadow-md">
                    <div class="relative z-10 flex flex-col items-center justify-center">
                        <div class="text-2xl font-bold text-indigo-900">{{ number_format($user->reviews->count() ?? 0) }}</div>
                        <div class="text-xs font-medium text-indigo-600">{{ __("Reviews") }}</div>
                    </div>
                    <div class="absolute -right-6 -top-6 h-16 w-16 rounded-full bg-indigo-100/50 transition group-hover:scale-150"></div>
                    <div class="absolute -bottom-6 -left-6 h-16 w-16 rounded-full bg-indigo-100/50 transition group-hover:scale-150"></div>
                </div>

                {{-- Credits --}}
                <div class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-green-50 to-green-100/50 p-4 transition hover:shadow-md">
                    <div class="relative z-10 flex flex-col items-center justify-center">
                        <div class="text-2xl font-bold text-green-900">{{ number_format($user->profile?->credit_balance ?? 0) }}</div>
                        <div class="text-xs font-medium text-green-600">{{ __("Credits") }}</div>
                    </div>
                    <div class="absolute -right-6 -top-6 h-16 w-16 rounded-full bg-green-100/50 transition group-hover:scale-150"></div>
                    <div class="absolute -bottom-6 -left-6 h-16 w-16 rounded-full bg-green-100/50 transition group-hover:scale-150"></div>
                </div>
            </div>
        </div>
    </div>
</div>