@props(['member'])

@php
    $status = $member->profile?->status ?? \App\Enums\UserProfileStatus::NotActive;
    $color = match ($status->getColor()) {
        'success' => 'bg-success-50 text-success-700 ring-success-600/20',
        'warning' => 'bg-warning-50 text-warning-700 ring-warning-600/20',
        'danger' => 'bg-danger-50 text-danger-700 ring-danger-600/20',
        'info' => 'bg-info-50 text-info-700 ring-info-600/20',
        'gray' => 'bg-gray-50 text-gray-700 ring-gray-600/20',
        default => 'bg-gray-50 text-gray-700 ring-gray-600/20',
    };
@endphp

<div class="z-0 p-4 mb-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-950/5">
    <div class="flex flex-col gap-4 md:flex-row md:items-center md:justify-between">
        <div class="flex items-center gap-3">
            <div class="inline-flex items-center gap-1.5 rounded-full px-3 py-1 text-sm font-medium ring-1 ring-inset {{ $color }}">
                <x-dynamic-component :component="'heroicon-s-' . str_replace('heroicon-o-', '', $status->getIcon())" class="w-4 h-4" />
                {{ $status->getLabel() }}
            </div>
            <span class="text-sm font-medium text-gray-600">ID #{{ $member->id }}</span>
        </div>

        @if (!$member->trashed())
            <div class="flex flex-wrap items-center gap-3">
                {{-- View Profile Button - Blue theme like Views stat --}}
                <a href="{{ route('member.show', ['slug' => $member->slug]) }}" target="_blank" class="relative inline-flex items-center gap-2 px-4 py-2 overflow-hidden text-sm font-medium text-blue-700 transition duration-200 rounded-lg group bg-gradient-to-br from-blue-50 to-blue-100/50 hover:bg-blue-100/70 ring-1 ring-blue-100 hover:ring-blue-200">
                    <span class="relative z-10 inline-flex items-center gap-2">
                        <x-heroicon-m-eye class="w-4 h-4 transition-transform duration-200 ease-out group-hover:scale-110" />
                        View Profile
                    </span>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -right-6 -top-6 bg-blue-100/50 group-hover:scale-150"></div>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -bottom-6 -left-6 bg-blue-100/50 group-hover:scale-150"></div>
                </a>

                {{-- Login as Member Button - Indigo theme like Reviews stat --}}
                <button type="button" class="relative inline-flex items-center gap-2 px-4 py-2 overflow-hidden text-sm font-medium text-indigo-700 transition duration-200 rounded-lg group bg-gradient-to-br from-indigo-50 to-indigo-100/50 hover:bg-indigo-100/70 ring-1 ring-indigo-100 hover:ring-indigo-200">
                    <span class="relative z-10 inline-flex items-center gap-2">
                        <x-heroicon-m-arrow-right-on-rectangle class="w-4 h-4 transition-transform duration-200 ease-out group-hover:scale-110" />
                        Login as Member
                    </span>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -right-6 -top-6 bg-indigo-100/50 group-hover:scale-150"></div>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -bottom-6 -left-6 bg-indigo-100/50 group-hover:scale-150"></div>
                </button>

                {{-- Send Email Button - Green theme like Credits stat --}}
                <button type="button" class="relative inline-flex items-center gap-2 px-4 py-2 overflow-hidden text-sm font-medium text-green-700 transition duration-200 rounded-lg group bg-gradient-to-br from-green-50 to-green-100/50 hover:bg-green-100/70 ring-1 ring-green-100 hover:ring-green-200">
                    <span class="relative z-10 inline-flex items-center gap-2">
                        <x-heroicon-m-envelope class="w-4 h-4 transition-transform duration-200 ease-out group-hover:scale-110" />
                        Send Email
                    </span>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -right-6 -top-6 bg-green-100/50 group-hover:scale-150"></div>
                    <div class="absolute w-16 h-16 transition-transform duration-500 ease-out rounded-full -bottom-6 -left-6 bg-green-100/50 group-hover:scale-150"></div>
                </button>
            </div>
        @endif
    </div>
</div>
