<div class="p-6">
    <h3 class="text-lg font-semibold text-dark-blue mb-4">Credit Transaction Details</h3>
    
    <div class="space-y-4">
        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Transaction ID</label>
                <p class="text-sm text-dark-blue">{{ $record->uuid }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Date</label>
                <p class="text-sm text-dark-blue">{{ $record->created_at->format('M d, Y') }}</p>
            </div>
        </div>
        
        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Credit</label>
                <p class="text-sm text-dark-blue">{{ $record->credit }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Debit</label>
                <p class="text-sm text-dark-blue">{{ $record->debit }}</p>
            </div>
        </div>
        
        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Balance</label>
                <p class="text-sm text-dark-blue">{{ $record->balance }}</p>
            </div>
            <div>
                <label class="block text-sm font-medium text-dark-blue/70">Type</label>
                <p class="text-sm text-dark-blue">{{ $record->creditable_type ?? 'N/A' }}</p>
            </div>
        </div>
        
        @if($record->description)
        <div>
            <label class="block text-sm font-medium text-dark-blue/70">Description</label>
            <p class="text-sm text-dark-blue">{{ $record->description }}</p>
        </div>
        @endif
        
        @if($record->created_by)
        <div>
            <label class="block text-sm font-medium text-dark-blue/70">Created By</label>
            <p class="text-sm text-dark-blue">{{ $record->author->name ?? 'System' }}</p>
        </div>
        @endif
    </div>
</div> 