@php
    use App\Helpers\DashboardSidebar;
    use Illuminate\Support\Facades\Route;
    use Illuminate\Support\Facades\Gate;
@endphp

<div>
    <div class="">
        <ul>
            @foreach (DashboardSidebar::getMenuItems() as $item)
                @if (DashboardSidebar::hasPermission($item))
                    <li class="px-4">
                        @if (isset($item['has_dropdown']) && $item['has_dropdown'])
                            @php
                                $isActive = DashboardSidebar::isActive($item);
                            @endphp
                            <div x-data="{ open: {{ $isActive ? 'true' : 'false' }} }">
                                <a href="#"
                                    class="group min-h-12 hover:text-blue-1200 hover:after:opacity-100 hover:transition-all hover:duration-500 hover:ease-in-out flex items-center text-dark-blue text-base font-normal tracking-0.3 leading-normal rounded-md gap-4 py-2.5 px-3 relative after:absolute after:content='' after:top-0 after:-left-4 after:w-1.5 after:h-full after:bg-blue-1200 after:opacity-0 after:rounded-r-md transition-all duration-500 ease-in-out {{ $isActive ? 'text-white bg-blue-1200 shadow-4xl after:opacity-100 hover:text-white' : '' }}"
                                    @click.prevent="open = !open">
                                    <span class="flex justify-center items-center w-full max-w-7">
                                        <x-dynamic-component :component="'dashboard.icons.' . $item['icon']" />
                                    </span>
                                    <p class="flex flex-1 gap-2 items-center w-full">
                                        {{ __($item['name']) }}
                                        <img src="{{ asset('images/dashboard/images/down-arrow.svg') }}"
                                            alt=""
                                            class="transition-all duration-500 ease-in-out transform"
                                            :class="{ 'rotate-180': open }" />
                                    </p>
                                </a>
                                <ul x-show="open"
                                    x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0"
                                    x-transition:leave="transition ease-in duration-300"
                                    x-transition:leave-start="opacity-100 transform translate-y-0"
                                    x-transition:leave-end="opacity-0 transform -translate-y-2"
                                    class="-mx-4 bg-blue-1200/[0.03] pb-[5px]"
                                    style="{{ $isActive ? 'display: block;' : 'display: none;' }}">
                                    @foreach ($item['submenu'] as $submenu)
                                        @if (DashboardSidebar::hasPermission($submenu))
                                            <li class="px-4">
                                                @if (isset($submenu['route']))
                                                    <a href="{{ route($submenu['route']) }}"
                                                        wire:navigate
                                                        class="pl-14 pr-2.5 hover:text-blue-1200 font-normal text-base tracking-0.3 flex items-center py-2 hover:transition-all hover:duration-500 hover:ease-in-out hover:after:opacity-100 relative after:absolute after:content='' after:top-0 after:-left-4 after:w-1.5 after:h-full after:bg-blue-1200 after:opacity-0 after:rounded-r-md transition-all duration-500 ease-in-out {{ DashboardSidebar::getSubmenuActiveClasses($submenu) }}">
                                                        {{ __($submenu['name']) }}
                                                    </a>
                                                @endif
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        @else
                            @if (isset($item['route']))
                                <a href="{{ route($item['route']) }}"
                                    wire:navigate
                                    @if ($item['exact'] ?? false) wire:current.exact="{{ DashboardSidebar::getActiveClasses($item) }}"
                                   @else
                                       wire:current="{{ DashboardSidebar::getActiveClasses($item) }}" @endif
                                    class="group min-h-12 hover:text-blue-1200 hover:after:opacity-100 hover:transition-all hover:duration-500 hover:ease-in-out flex items-center text-dark-blue text-base font-normal tracking-0.3 leading-normal rounded-md gap-4 py-2.5 px-3 relative after:absolute after:content='' after:top-0 after:-left-4 after:w-1.5 after:h-full after:bg-blue-1200 after:opacity-0 after:rounded-r-md transition-all duration-500 ease-in-out">
                                    <span class="flex justify-center items-center w-full max-w-7">
                                        <x-dynamic-component :component="'dashboard.icons.' . $item['icon']" />
                                    </span>
                                    <p class="flex-1 w-full">{{ __($item['name']) }}</p>
                                </a>
                            @endif
                        @endif
                    </li>
                @endif
            @endforeach
        </ul>
    </div>
</div>

@push('scripts')
    <script>
        document.addEventListener('alpine:init', () => {
            // Keep dropdowns open on page load if they contain active items
            document.querySelectorAll('[data-collapse-toggle]').forEach(toggle => {
                const dropdownId = toggle.getAttribute('aria-controls');
                const dropdown = document.getElementById(dropdownId);

                if (dropdown && toggle.classList.contains('text-white')) {
                    dropdown.classList.remove('hidden');
                }
            });
        });
    </script>
@endpush
