@php use Illuminate\Support\Str; @endphp
@props(['favorite'])

<div class="bg-white rounded-lg border border-gray-200 overflow-hidden transition-shadow hover:shadow-lg">
    <div class="md:flex">
        <!-- Featured Image -->
        <div class="md:w-48 md:flex-shrink-0">
            @if ($favorite->model->getFirstMediaUrl('gallery'))
                <img class="h-48 w-full md:w-48 object-cover" 
                     src="{{ $favorite->model->getFirstMediaUrl('gallery') }}" 
                     alt="{{ $favorite->model->title }}">
            @else
                <div class="h-48 w-full md:w-48 bg-gray-300 flex items-center justify-center">
                    <svg class="h-12 w-12 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd" />
                    </svg>
                </div>
            @endif
        </div>
        
        <!-- Content -->
        <div class="p-6 flex-1 flex justify-between">
            <div class="flex-1">
                <h3 class="text-xl font-semibold text-gray-900 mb-2">
                    <a href="{{ route('classified.show', $favorite->model->slug) }}" class="hover:text-indigo-600">
                        {{ $favorite->model->title }}
                    </a>
                </h3>
                
                <!-- Price Information -->
                <div class="flex items-center space-x-2 mb-3">
                    @if ($favorite->model->discount_price && $favorite->model->discount_price < $favorite->model->price)
                        <span class="text-2xl font-bold text-green-600">${{ number_format($favorite->model->discount_price, 2) }}</span>
                        <span class="text-lg text-gray-500 line-through">${{ number_format($favorite->model->price, 2) }}</span>
                        @php
                            $discountPercentage = $favorite->model->price > 0 ? round((($favorite->model->price - $favorite->model->discount_price) / $favorite->model->price) * 100) : 0;
                        @endphp
                        @if ($discountPercentage > 0)
                            <span class="px-2 py-1 bg-red-100 text-red-800 text-xs rounded-full">
                                {{ $discountPercentage }}% OFF
                            </span>
                        @endif
                    @else
                        <span class="text-2xl font-bold text-gray-900">${{ number_format($favorite->model->price, 2) }}</span>
                    @endif
                </div>

                <!-- Details -->
                <div class="grid grid-cols-2 gap-4 mb-3 text-sm text-gray-600">
                    @if ($favorite->model->condition)
                        <div>
                            <span class="font-medium">Condition:</span> 
                            <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-xs">{{ $favorite->model->condition->getLabel() }}</span>
                        </div>
                    @endif
                    @if ($favorite->model->manufacture_date)
                        <div>
                            <span class="font-medium">Year:</span> {{ \Carbon\Carbon::parse($favorite->model->manufacture_date)->format('Y') }}
                        </div>
                    @endif
                    @if ($favorite->model->getAddress('area'))
                        <div>
                            <span class="font-medium">Location:</span> {{ $favorite->model->getAddress('area') }}
                        </div>
                    @endif
                </div>

                <!-- Added to favorites date -->
                <div class="text-sm text-gray-600">
                    <span class="font-medium">Added to favorites:</span> {{ $favorite->created_at->format('M d, Y') }}
                </div>
            </div>
            
            <!-- Remove Button -->
            <div class="ml-6 flex-shrink-0">
                <button wire:click="removeFavorite({{ $favorite->model_id }})"
                    wire:confirm="Are you sure you want to remove this item from your favourites?"
                    class="inline-flex items-center px-3 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md hover:bg-red-200 transition-colors">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                    Remove
                </button>
            </div>
        </div>
    </div>
</div>