@php use Illuminate\Support\Str; @endphp
@props(['favorite'])

<div class="bg-white rounded-lg border border-gray-200 overflow-hidden transition-shadow hover:shadow-lg">
    <div class="p-6 flex justify-between items-start">
        <div class="flex-1">
            <h3 class="text-xl font-semibold text-gray-900 mb-2">
                <a href="{{ route('job.show', $favorite->model->slug) }}" class="hover:text-indigo-600">
                    {{ $favorite->model->job_title }}
                </a>
            </h3>
            
            <!-- Company Information -->
            @if ($favorite->model->user)
                <div class="mb-3">
                    <span class="font-medium text-gray-700">Company:</span> 
                    <a href="{{ $favorite->model->user->permalink }}" class="text-indigo-600 hover:text-indigo-800">
                        {{ $favorite->model->user->memberName() }}
                    </a>
                </div>
            @endif
            
            <!-- Job Details Grid -->
            <div class="grid grid-cols-2 gap-4 mb-3 text-sm text-gray-600">
                @if ($favorite->model->address('short'))
                    <div><span class="font-medium">Location:</span> {{ $favorite->model->address('short') }}</div>
                @endif
                
                @if ($favorite->model->jobRole())
                    <div><span class="font-medium">Role:</span> {{ $favorite->model->jobRole() }}</div>
                @endif
                
                @if ($favorite->model->jobIndustry())
                    <div><span class="font-medium">Industry:</span> {{ $favorite->model->jobIndustry() }}</div>
                @endif
                
                @if ($favorite->model->jobCarerLevel())
                    <div><span class="font-medium">Career Level:</span> {{ $favorite->model->jobCarerLevel() }}</div>
                @endif
                
                @if ($favorite->model->saleryRange())
                    <div><span class="font-medium">Salary:</span> {{ $favorite->model->saleryRange() }}</div>
                @endif
                
                @if ($favorite->model->job_shift)
                    <div><span class="font-medium">Shift:</span> {{ $favorite->model->job_shift->getLabel() }}</div>
                @endif
                
                @if ($favorite->model->workMode())
                    <div><span class="font-medium">Work Mode:</span> {{ $favorite->model->workMode() }}</div>
                @endif
            </div>
            
            <!-- Added to favorites date -->
            <div class="text-sm text-gray-600">
                <span class="font-medium">Added to favorites:</span> {{ $favorite->created_at->format('M d, Y') }}
            </div>
        </div>
        
        <button wire:click="removeFavorite({{ $favorite->model_id }})"
            wire:confirm="Are you sure you want to remove this item from your favourites?"
            class="ml-6 inline-flex items-center px-3 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md hover:bg-red-200 transition-colors">
            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
            </svg>
            Remove
        </button>
    </div>
</div>