@php use Illuminate\Support\Str; @endphp
@props(['favorite'])

<div class="bg-white rounded-lg border border-gray-200 overflow-hidden transition-shadow hover:shadow-lg">
    <div class="md:flex">
        <!-- Featured Image -->
        <div class="md:w-48 md:flex-shrink-0">
            @if ($favorite->model->getFirstMediaUrl('featured_image'))
                <img class="h-48 w-full md:w-48 object-cover" 
                     src="{{ $favorite->model->getFirstMediaUrl('featured_image') }}" 
                     alt="{{ $favorite->model->title }}">
            @else
                <div class="h-48 w-full md:w-48 bg-gray-300 flex items-center justify-center">
                    <svg class="h-12 w-12 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z" clip-rule="evenodd" />
                    </svg>
                </div>
            @endif
        </div>
        
        <div class="p-6 flex-1 flex justify-between">
            <div class="flex-1">
                <h3 class="text-xl font-semibold text-gray-900 mb-2">
                    <a href="{{ route('blog.post.show', $favorite->model->slug) }}" class="hover:text-indigo-600">
                        {{ $favorite->model->title }}
                    </a>
                </h3>
                
                <div class="mb-3 text-sm text-gray-600">
                    @if ($favorite->model->author)
                        <div><span class="font-medium">Author:</span> {{ $favorite->model->author->name }}</div>
                    @endif
                    @if ($favorite->model->published_at)
                        <div><span class="font-medium">Published:</span> {{ $favorite->model->published_at->format('M d, Y') }}</div>
                    @endif
                </div>
                
                <p class="text-gray-600 mb-3">{{ Str::limit($favorite->model->excerpt ?? $favorite->model->meta_description, 120) }}</p>
                <div class="text-xs text-gray-500">Added: {{ $favorite->created_at->format('M d, Y') }}</div>
            </div>
            
            <div class="ml-6 flex-shrink-0">
                <button wire:click="removeFavorite({{ $favorite->model_id }})"
                    wire:confirm="Are you sure you want to remove this item from your favourites?"
                    class="inline-flex items-center px-3 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md hover:bg-red-200 transition-colors">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                    Remove
                </button>
            </div>
        </div>
    </div>
</div>