@php use Illuminate\Support\Str; @endphp
@props(['favorite'])

<div class="overflow-hidden bg-white rounded-lg border border-gray-200 transition-shadow hover:shadow-lg">
    <div class="md:flex">
        <!-- Featured Image -->
        <div class="md:w-48 md:flex-shrink-0">
            @if ($favorite->model->getFirstMediaUrl('gallery'))
                <img class="object-cover w-full h-48 md:w-48"
                    src="{{ $favorite->model->getFirstMediaUrl('gallery') }}"
                    alt="{{ $favorite->model->title }}">
            @else
                <div class="flex justify-center items-center w-full h-48 bg-gray-300 md:w-48">
                    <svg class="w-12 h-12 text-gray-400"
                        fill="currentColor"
                        viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"
                            clip-rule="evenodd" />
                    </svg>
                </div>
            @endif
        </div>

        <div class="flex flex-1 justify-between p-6">
            <div class="flex-1">
                <h3 class="mb-2 text-xl font-semibold text-gray-900">
                    <a href="{{ route('project.show', $favorite->model->slug) }}" class="hover:text-indigo-600">
                        {{ $favorite->model->title }}
                    </a>
                </h3>

                <!-- Project Details Grid -->
                <div class="grid grid-cols-2 gap-4 mb-3 text-sm text-gray-600">
                    @if ($favorite->model->address('full'))
                        <div><span class="font-medium">Location:</span> {{ $favorite->model->address('area') }}</div>
                    @endif

                    @if ($favorite->model->getProjectCost())
                        <div><span class="font-medium">Project Cost:</span> ${{ number_format($favorite->model->getProjectCost(), 2) }}</div>
                    @endif

                    @if ($favorite->model->getProjectStatus())
                        <div><span class="font-medium">Status:</span> {{ $favorite->model->getProjectStatus() }}</div>
                    @endif
                </div>

                <!-- Added to favorites date -->
                <div class="text-sm text-gray-600">
                    <span class="font-medium">Added to favorites:</span> {{ $favorite->created_at->format('M d, Y') }}
                </div>
            </div>

            <div class="flex-shrink-0 ml-6">
                <button wire:click="removeFavorite({{ $favorite->model_id }})"
                    wire:confirm="Are you sure you want to remove this item from your favourites?"
                    class="inline-flex items-center px-3 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md transition-colors hover:bg-red-200">
                    <svg class="mr-1 w-4 h-4"
                        fill="none"
                        stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                    Remove
                </button>
            </div>
        </div>
    </div>
</div>
