@php use Illuminate\Support\Str; @endphp
@props(['favorite'])

<div class="bg-white rounded-lg border border-gray-200 overflow-hidden transition-shadow hover:shadow-lg">
    <div class="md:flex">
        <!-- Profile Image -->
        <div class="md:w-48 md:flex-shrink-0">
            @if ($favorite->model->logoImage())
                <img class="h-48 w-full md:w-48 object-cover" 
                     src="{{ $favorite->model->logoImage() }}" 
                     alt="{{ $favorite->model->name }}">
            @else
                <div class="h-48 w-full md:w-48 bg-gray-300 flex items-center justify-center">
                    <svg class="h-12 w-12 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6-3a2 2 0 11-4 0 2 2 0 014 0zm-2 4a5 5 0 00-4.546 2.916A5.986 5.986 0 0010 16a5.986 5.986 0 004.546-2.084A5 5 0 0010 11z" clip-rule="evenodd" />
                    </svg>
                </div>
            @endif
        </div>
        
        <div class="p-6 flex-1 flex justify-between">
            <div class="flex-1">
                <h3 class="text-xl font-semibold text-gray-900 mb-2">
                    <a href="{{ route('member.show', $favorite->model->slug) }}" class="hover:text-indigo-600">
                        {{ $favorite->model->memberName() }}
                    </a>
                </h3>
                
                <!-- Star Rating -->
                @php
                    $ratingData = $favorite->model->ratingCount();
                    $rating = $ratingData['rating'] ?? 0;
                    $count = $ratingData['count'] ?? 0;
                @endphp
                @if ($rating > 0)
                    <div class="flex items-center mb-3">
                        <div class="flex text-yellow-400">
                            @for ($i = 1; $i <= 5; $i++)
                                @if ($i <= floor($rating))
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                    </svg>
                                @elseif ($i == ceil($rating) && $rating - floor($rating) >= 0.5)
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <defs>
                                            <linearGradient id="half-fill">
                                                <stop offset="50%" stop-color="currentColor"/>
                                                <stop offset="50%" stop-color="transparent"/>
                                            </linearGradient>
                                        </defs>
                                        <path fill="url(#half-fill)" d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                    </svg>
                                @else
                                    <svg class="w-4 h-4 text-gray-300" viewBox="0 0 20 20" fill="currentColor">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                    </svg>
                                @endif
                            @endfor
                        </div>
                        <span class="ml-2 text-sm text-gray-600">{{ $rating }} ({{ $count }} {{ $count == 1 ? 'review' : 'reviews' }})</span>
                    </div>
                @endif
                
                <!-- Member Details -->
                <div class="grid grid-cols-2 gap-4 mb-3 text-sm text-gray-600">
                    @if ($favorite->model->address('area'))
                        <div><span class="font-medium">Location:</span> {{ $favorite->model->address('area') }}</div>
                    @endif
                    
                    @if ($favorite->model->memberCategories && $favorite->model->memberCategories->count() > 0)
                        @php
                            $categoryNames = $favorite->model->memberCategories->pluck('category_name')->take(2)->filter()->implode(', ');
                        @endphp
                        @if ($categoryNames)
                            <div><span class="font-medium">Categories:</span> {{ $categoryNames }}</div>
                        @endif
                    @endif
                </div>
                
                <!-- Added to favorites date -->
                <div class="text-sm text-gray-600">
                    <span class="font-medium">Added to favorites:</span> {{ $favorite->created_at->format('M d, Y') }}
                </div>
            </div>
            
            <div class="ml-6 flex-shrink-0">
                <button wire:click="removeFavorite({{ $favorite->model_id }})"
                    wire:confirm="Are you sure you want to remove this item from your favourites?"
                    class="inline-flex items-center px-3 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-md hover:bg-red-200 transition-colors">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                    Remove
                </button>
            </div>
        </div>
    </div>
</div>