<div>
    <h4 class="mb-4 text-base font-medium leading-none text-dark-blue sm:text-22 tracking-32p sm:mb-6">
        {{ __('Business Information') }}
    </h4>
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-8">
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Business Name') }}
            </label>
            <input type="text" wire:model.live="company_name" class="{{ $inputClass }} @error('company_name') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Enter your business name') }}" />
            @error('company_name')
                <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Business Website') }}
            </label>
            <input type="url" wire:model.live="website" class="{{ $inputClass }} @error('website') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('(e.g. www.site.com)') }}" />
            @error('website')
                <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Year Established') }}
            </label>
            <input type="number" wire:model="year_established" class="{{ $inputClass }} @error('year_established') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Enter year established') }}" min="1800" max="{{ date('Y') }}" />
            @error('year_established')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Business Timezone') }}
            </label>
            <select wire:model.live="business_timezone" class="{{ $inputClass }} @error('business_timezone') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                <option value="">{{ __('Select timezone') }}</option>
                @foreach (timezone_identifiers_list() as $timezone)
                    <option value="{{ $timezone }}">{{ $timezone }}</option>
                @endforeach
            </select>
            @error('business_timezone')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
    </div>

    {{-- Business Description and Slogan --}}
    <div class="mt-6">
        <div class="mb-6">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Business Slogan') }}
            </label>
            <div x-data="{
                charCount: 0,
                maxChars: 200,
                remainingChars() { return this.maxChars - this.charCount },
                init() {
                    this.charCount = $wire.slogan ? $wire.slogan.length : 0;
                    $watch('$wire.slogan', (value) => { this.charCount = value ? value.length : 0; });
                }
            }" class="relative">
                <input type="text" wire:model.live="slogan" class="{{ $inputClass }} @error('slogan') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Enter a catchy slogan for your business (max 200 characters)') }}" maxlength="200" />
                <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                    <span x-text="charCount"></span> / <span x-text="maxChars"></span>
                </div>
            </div>
            @error('slogan')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        @can('userProfileBusinessDescription')
            <div class="">
                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('Business Description') }}
                </label>
                <div wire:ignore class="relative">
                    <div x-data="{
                        init() {
                            // Initialize TinyMCE
                            tinymce.init({
                                selector: '#editor-{{ $user->id }}',
                                plugins: 'lists link autolink autoresize',
                                toolbar: 'undo redo | formatselect | h2 h3 h4 | bold italic underline | bullist numlist',
                                menubar: false,
                                branding: false,
                                promotion: false,
                                readonly: false,
                                height: 300,
                                setup: function(editor) {
                                    editor.on('init', function(e) {
                                        editor.setContent(@this.about || '');
                                    });
                    
                                    editor.on('change input blur', function(e) {
                                        @this.set('about', editor.getContent());
                                        @this.set('isDirty', true);
                                    });
                                }
                            });
                        }
                    }">
                        <textarea id="editor-{{ $user->id }}" class="w-full"></textarea>
                    </div>
                </div>
                @error('about')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
        @endcan
    </div>

    {{-- Professional Credentials Section --}}
    @can('userProfileProfessionalCredentials')
        <div class="mt-6">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Professional Credentials') }}
                <span class="text-xs text-dark-blue/60">({{ __('e.g. Certifications, Licenses, Awards') }})</span>
            </label>

            <div class="">
                @foreach ($credentials as $key => $credential)
                    <div class="flex items-center p-3 mb-4 border border-gray-200 rounded-md bg-gray-50" wire:key="credential-{{ $key }}">
                        <div class="grid grid-cols-2 gap-4 flex-1">
                            <div class="relative">
                                <select wire:model.live="credentials.{{ $key }}.credential_type" class="{{ $inputClass }} @error('credentials.' . $key . '.credential_type') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                                    @foreach (\App\Enums\ProfessionalCredentionals::cases() as $credential)
                                        <option value="{{ $credential->value }}">{{ $credential->getLabel() }}</option>
                                    @endforeach
                                </select>
                                @error('credentials.' . $key . '.credential_type')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="relative">
                                <textarea wire:model.live="credentials.{{ $key }}.credential_value" rows="3" class="{{ $inputClass }} @error('credentials.' . $key . '.credential_value') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror pr-16 resize-none" placeholder="{{ __('Enter credential') }}" maxlength="100"></textarea>
                                <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                                    <span x-data x-text="$wire.credentials['{{ $key }}']?.credential_value?.length || 0"></span>/100
                                </div>
                                @error('credentials.' . $key . '.credential_value')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <button type="button" wire:click="removeCredential('{{ $key }}')" class="ml-3 text-red-500 shrink-0 hover:text-red-600 focus:outline-none">
                            <x-heroicon-o-x-mark class="w-4 h-4" />
                        </button>
                    </div>
                @endforeach

                @if (count($credentials) < 4)
                    <div class="flex items-center gap-3">
                        <button type="button" wire:click="addCredential" class="flex items-center gap-2 px-3 py-1.5 text-sm font-medium border rounded-md text-blue-1200 border-blue-1200 hover:bg-blue-50">
                            <x-heroicon-o-plus class="w-4 h-4" />
                            {{ __('Add Credential') }}
                        </button>
                        <x-common.spinner wire:loading wire:target="addCredential" />
                    </div>
                @endif

                <p class="mt-2 text-xs text-dark-blue/60">
                    {{ __(':count of 4 credentials used', ['count' => count($credentials)]) }}
                </p>
            </div>
        </div>
    @endcan

    {{-- Awards & Recognitions Section --}}
    @can('userProfileAwardsRecognitions')
        <div class="mt-6">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Awards & Recognitions') }}
                <span class="text-xs text-dark-blue/60">({{ __('e.g. Industry Awards, Achievements') }})</span>
            </label>

            <div class="">
                @foreach ($awardsRecognitions as $key => $award)
                    <div class="flex items-center p-3 mb-4 border border-gray-200 rounded-md bg-gray-50" wire:key="award-{{ $key }}">
                        <div class="flex items-center flex-1 gap-4">
                            {{-- Award Title --}}
                            <div class="relative flex-1">
                                <textarea wire:model.live="awards_recognitions.{{ $key }}.title" rows="3" class="w-full {{ $inputClass }} @error('awards_recognitions.' . $key . '.title') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror pr-16 resize-none" placeholder="{{ __('Enter award or recognition title') }}" maxlength="100"></textarea>
                                <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                                    <span x-data x-text="$wire.awards_recognitions['{{ $key }}']?.title?.length || 0"></span>/100
                                </div>
                                @error('awards_recognitions.' . $key . '.title')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Award Year --}}
                            <div class="w-32">
                                <input type="number" wire:model.live="awards_recognitions.{{ $key }}.year" class="{{ $inputClass }} @error('awards_recognitions.' . $key . '.year') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Year') }}" min="1800" max="{{ date('Y') }}" />
                                @error('awards_recognitions.' . $key . '.year')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Delete Button --}}
                            <button type="button" wire:click="removeAward('{{ $key }}')" class="text-red-500 shrink-0 hover:text-red-600 focus:outline-none">
                                <x-heroicon-o-x-mark class="w-4 h-4" />
                            </button>
                        </div>
                    </div>
                @endforeach

                @if (count($awardsRecognitions) < 4)
                    <div class="flex items-center gap-3">
                        <button type="button" wire:click="addAward" class="flex items-center gap-2 px-3 py-1.5 text-sm font-medium border rounded-md text-blue-1200 border-blue-1200 hover:bg-blue-50">
                            <x-heroicon-o-plus class="w-4 h-4" />
                            {{ __('Add Award') }}
                        </button>
                        <x-common.spinner wire:loading wire:target="addAward" />
                    </div>
                @endif

                <p class="mt-2 text-xs text-dark-blue/60">
                    {{ __(':count of 4 awards used', ['count' => count($awardsRecognitions)]) }}
                </p>
            </div>
        </div>
    @endcan

    {{-- Business Hours --}}
    @can('userProfileBusinessHours')
        <div class="mt-8">
            <label class="flex items-center gap-2 mb-4 text-sm font-normal leading-none text-dark-blue">
                {{ __('Business Hours') }}
            </label>

            <div class="space-y-3">
                @foreach (['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'] as $day)
                    @php
                        $dayData = $businessHours[$day] ?? [
                            'day_of_week' => $day,
                            'day_label' => ucfirst($day),
                            'is_open' => false,
                            'hours_label' => '',
                            'open_time' => '09:00',
                            'close_time' => '17:00',
                        ];
                    @endphp
                    <div class="p-3 border border-dark-blue/[0.2] rounded-md bg-gray-50" wire:key="business-hours-{{ $day }}">
                        <div class="flex flex-col gap-3 lg:flex-row lg:items-center lg:space-x-4">
                            {{-- Day Label (Fixed) --}}
                            <div class="lg:w-24 shrink-0">
                                <span class="text-sm font-medium text-dark-blue">
                                    {{ $dayData['day_label'] }}
                                </span>
                                <input type="hidden" wire:model="business_hours.{{ $day }}.day_of_week" value="{{ $day }}" />
                                <input type="hidden" wire:model="business_hours.{{ $day }}.day_label" value="{{ $dayData['day_label'] }}" />
                            </div>

                            {{-- Open/Close Toggle --}}
                            <div class="flex items-center shrink-0">
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" wire:model.live="business_hours.{{ $day }}.is_open" class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-1200"></div>
                                    <span class="text-sm font-medium ms-3 text-dark-blue whitespace-nowrap">
                                        {{ $dayData['is_open'] ? __('Open') : __('Closed') }}
                                    </span>
                                </label>
                            </div>

                            {{-- Hours Label Input --}}
                            <div class="lg:w-48">
                                <div class="relative">
                                    <input type="text" wire:model.live="business_hours.{{ $day }}.hours_label" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('business_hours.' . $day . '.hours_label') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror pr-16" placeholder="{{ __('e.g. Regular Hours') }}" maxlength="30" />
                                    <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                                        <span x-data x-text="$wire.business_hours['{{ $day }}']?.hours_label?.length || 0"></span>/30
                                    </div>
                                </div>
                                @error('business_hours.' . $day . '.hours_label')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Hours Input with Time Selects --}}
                            @if ($dayData['is_open'])
                                <div class="flex items-center gap-2 lg:flex-1">
                                    <select wire:model.live="business_hours.{{ $day }}.open_time" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('business_hours.' . $day . '.open_time') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                                        @foreach (range(0, 23) as $hour)
                                            <option value="{{ sprintf('%02d:00', $hour) }}">{{ sprintf('%02d:00', $hour) }}</option>
                                            <option value="{{ sprintf('%02d:30', $hour) }}">{{ sprintf('%02d:30', $hour) }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-sm text-dark-blue whitespace-nowrap">to</span>
                                    <select wire:model.live="business_hours.{{ $day }}.close_time" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('business_hours.' . $day . '.close_time') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                                        @foreach (range(0, 23) as $hour)
                                            <option value="{{ sprintf('%02d:00', $hour) }}">{{ sprintf('%02d:00', $hour) }}</option>
                                            <option value="{{ sprintf('%02d:30', $hour) }}">{{ sprintf('%02d:30', $hour) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                        </div>
                        @error('business_hours.' . $day . '.open_time')
                            <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                        @enderror
                        @error('business_hours.' . $day . '.close_time')
                            <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                @endforeach
            </div>
        </div>
    @endcan
    {{-- Seasonal Hours Section --}}
    @can('userProfileSeasonalHours')
        <div class="mt-8">
            <label class="flex items-center gap-2 mb-4 text-sm font-normal leading-none text-dark-blue">
                {{ __('Seasonal Hours') }}
                <span class="text-xs text-dark-blue/60">({{ __('e.g. Summer Hours, Holiday Hours') }})</span>
            </label>

            <div class="space-y-3">
                @foreach ($seasonalHours as $key => $hours)
                    <div class="p-3 border border-dark-blue/[0.2] bg-gray-50 rounded-md" wire:key="seasonal-hours-{{ $key }}">
                        <div class="grid grid-cols-1 gap-3 lg:grid-cols-[auto_1fr_2fr_1fr_2fr_auto] lg:items-center">
                            {{-- Open/Close Toggle --}}
                            <div class="flex items-center">
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" wire:model.live="seasonal_hours.{{ $key }}.is_open" class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-1200"></div>
                                    <span class="text-sm font-medium ms-3 text-dark-blue whitespace-nowrap">
                                        {{ $hours['is_open'] ? __('Open') : __('Closed') }}
                                    </span>
                                </label>
                            </div>

                            {{-- Season Name --}}
                            <div>
                                <div class="relative">
                                    <input type="text" wire:model.live="seasonal_hours.{{ $key }}.season_name" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.season_name') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror pr-16" placeholder="{{ __('e.g. Summer') }}" maxlength="20" />
                                    <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                                        <span x-data x-text="$wire.seasonal_hours['{{ $key }}']?.season_name?.length || 0"></span>/20
                                    </div>
                                </div>
                                @error('seasonal_hours.' . $key . '.season_name')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Date Range with Date Pickers --}}
                            <div class="flex items-center gap-2">
                                <input type="date" wire:model.live="seasonal_hours.{{ $key }}.start_date" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.start_date') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" />
                                <span class="text-sm text-dark-blue whitespace-nowrap">to</span>
                                <input type="date" wire:model.live="seasonal_hours.{{ $key }}.end_date" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.end_date') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" />
                            </div>

                            @if ($hours['is_open'])
                                {{-- Days Input --}}
                                <div>
                                    <div class="relative">
                                        <input type="text" wire:model.live="seasonal_hours.{{ $key }}.days" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.days') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror pr-16" placeholder="{{ __('e.g. Mon-Fri') }}" maxlength="20" />
                                        <div class="absolute text-xs bottom-2 right-3 text-dark-blue/60">
                                            <span x-data x-text="$wire.seasonal_hours['{{ $key }}']?.days?.length || 0"></span>/20
                                        </div>
                                    </div>
                                    @error('seasonal_hours.' . $key . '.days')
                                        <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                {{-- Hours Input with Time Selects --}}
                                <div class="flex items-center gap-2">
                                    <select wire:model.live="seasonal_hours.{{ $key }}.start_time" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.start_time') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                                        @foreach (range(0, 23) as $hour)
                                            <option value="{{ sprintf('%02d:00', $hour) }}">{{ sprintf('%02d:00', $hour) }}</option>
                                            <option value="{{ sprintf('%02d:30', $hour) }}">{{ sprintf('%02d:30', $hour) }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-sm text-dark-blue whitespace-nowrap">to</span>
                                    <select wire:model.live="seasonal_hours.{{ $key }}.end_time" class="w-full px-2 py-1.5 text-sm {{ $inputClass }} @error('seasonal_hours.' . $key . '.end_time') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror">
                                        @foreach (range(0, 23) as $hour)
                                            <option value="{{ sprintf('%02d:00', $hour) }}">{{ sprintf('%02d:00', $hour) }}</option>
                                            <option value="{{ sprintf('%02d:30', $hour) }}">{{ sprintf('%02d:30', $hour) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            {{-- Delete Button --}}
                            {{-- <div class="flex items-center justify-end"> --}}
                                <button type="button" wire:click="removeSeasonalHours('{{ $key }}')" class="text-red-500 hover:text-red-600">
                                    <x-heroicon-o-x-mark class="w-4 h-4" />
                                </button>
                            {{-- </div> --}}
                        </div>
                    </div>
                @endforeach

                @if (count($seasonalHours) < 7)
                    <div class="flex items-center gap-3">
                        <button type="button" wire:click="addSeasonalHours" class="flex items-center gap-2 px-3 py-1.5 text-sm font-medium border rounded-md text-blue-1200 border-blue-1200 hover:bg-blue-50">
                            <x-heroicon-o-plus class="w-4 h-4" />
                            {{ __('Add Seasonal Hours') }}
                        </button>
                        <x-common.spinner wire:loading wire:target="addSeasonalHours" />
                    </div>
                @endif

                <p class="mt-2 text-xs text-dark-blue/60">
                    {{ __(':count of 7 seasonal hours entries used', ['count' => count($seasonalHours)]) }}
                </p>
            </div>
        </div>
    @endcan

    {{-- Profile Tags Section --}}
    @can('userProfileSeasonalHours')
        <div class="mt-8">
            <label for="profile-tag-input" class="flex items-center gap-2 mb-4 text-sm font-normal leading-none text-dark-blue">
                {{ __('Profile Tags') }}
                <span class="text-xs text-dark-blue/60">({{ __('Add up to 3 tags to highlight specialties or keywords') }})</span>
            </label>

            <div class="flex flex-col gap-4">
                <div>
                    <div class="relative">
                        <div wire:loading wire:target="addProfileTag" class="absolute z-10 -translate-y-1/2 right-3 top-1/2">
                            <x-common.spinner />
                        </div>
                        <input type="text" id="profile-tag-input" x-data @keydown.enter.prevent="$wire.addProfileTag($el.value); $el.value = ''" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11 pr-10" placeholder="{{ __('Add a tag and press Enter') }}" maxlength="20" />
                    </div>
                    <p class="mt-1.5 text-xs text-dark-blue/60">
                        {{ __('Maximum 3 tags. Each tag up to 20 characters.') }}
                    </p>
                </div>

                <div class="flex flex-wrap items-center gap-4">
                    @foreach ($profileTags ?? [] as $index => $tag)
                        <div class="inline-flex items-center px-4 py-2 text-sm rounded-full bg-blue-50 text-blue-1200">
                            <span>{{ $tag }}</span>
                            <button type="button" wire:click="removeProfileTag({{ $index }})" class="ml-2 text-blue-1200 hover:text-blue-800 focus:outline-none">
                                <x-heroicon-o-x-mark class="w-4 h-4" />
                            </button>
                        </div>
                    @endforeach
                </div>

                @error('profile_tags')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
                @error('profile_tags.*')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
        </div>
    @endcan
</div>
