<div>
    <h4 class="mb-4 text-base font-medium leading-none text-dark-blue sm:text-22 tracking-32p sm:mb-6">
        {{ __('Personal & Contact Information') }}
    </h4>
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-8">
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('First Name') }} <span class="flex items-center text-red-1200">*</span>
            </label>
            <input type="text" wire:model.live="first_name" class="{{ $inputClass }} @error('first_name') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('First Name') }}" />
            @error('first_name')
                <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Last Name') }} <span class="flex items-center text-red-1200">*</span>
            </label>
            <input type="text" wire:model.live="last_name" class="{{ $inputClass }} @error('last_name') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Last Name') }}" />
            @error('last_name')
                <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Email') }} <span class="flex items-center text-red-1200">*</span>
            </label>
            <input type="email" wire:model.live="email" class="{{ $inputClass }} @error('email') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('Enter your email address') }}" />
            @error('email')
                <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Contact Number') }} <span class="flex items-center text-red-1200">*</span>
            </label>
            <div x-data="{
                init() {
                    let phoneInput = $el.querySelector('input');
                    IMask(phoneInput, { mask: '(000) 000-0000' });
                }
            }">
                <input type="tel" wire:model.live="phone" class="{{ $inputClass }} @error('phone') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('(xxx) xxx-xxxx') }}" />
            </div>
            @error('phone')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="">
            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                {{ __('Mobile Number') }}
            </label>
            <div x-data="{
                init() {
                    let mobileInput = $el.querySelector('input');
                    IMask(mobileInput, { mask: '(000) 000-0000' });
                }
            }">
                <input type="tel" wire:model.live="mobile" class="{{ $inputClass }} @error('mobile') {{ $errorInputClass }} @else {{ $normalInputClass }} @enderror" placeholder="{{ __('(xxx) xxx-xxxx') }}" />
            </div>
            @error('mobile')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
    </div>
</div>
