<div>
    <h4 class="mb-4 text-base font-medium leading-none text-dark-blue sm:text-22 tracking-32p sm:mb-6">
        {{ __('Social Media Links') }}
    </h4>
    <div class="p-5 rounded-md bg-gray-50">
        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
            <div>
                <label for="facebook" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('Facebook') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-blue-600" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                        </svg>
                    </span>
                    <input type="url" id="facebook" wire:model.live="facebook" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://facebook.com/yourprofile" />
                </div>
                @error('facebook')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="instagram" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('Instagram') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-pink-600" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                        </svg>
                    </span>
                    <input type="url" id="instagram" wire:model.live="instagram" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://instagram.com/yourprofile" />
                </div>
                @error('instagram')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="twitter" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('X / Twitter') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-blue-400" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z" />
                        </svg>
                    </span>
                    <input type="url" id="twitter" wire:model.live="twitter" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://twitter.com/yourprofile" />
                </div>
                @error('twitter')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="linkedin" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('LinkedIn') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-blue-700" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z" />
                        </svg>
                    </span>
                    <input type="url" id="linkedin" wire:model.live="linkedin" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://linkedin.com/in/yourprofile" />
                </div>
                @error('linkedin')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="youtube" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('YouTube') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-600" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z" />
                        </svg>
                    </span>
                    <input type="url" id="youtube" wire:model.live="youtube" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://youtube.com/@yourchannel" />
                </div>
                @error('youtube')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="tiktok" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('TikTok') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-black" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z" />
                        </svg>
                    </span>
                    <input type="url" id="tiktok" wire:model.live="tiktok" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://tiktok.com/@yourusername" />
                </div>
                @error('tiktok')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label for="pinterest" class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                    {{ __('Pinterest') }}
                </label>
                <div class="relative flex items-stretch w-full rounded-md">
                    <span class="inline-flex items-center justify-center px-3 border border-r-0 border-dark-blue/[0.2] rounded-l-md bg-gray-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-700" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.162-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.401.165-1.79.06-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.354-.629-2.758-1.379l-.749 2.848c-.269 1.045-1.004 2.352-1.498 3.146 1.123.345 2.306.535 3.55.535 6.607 0 11.985-5.365 11.985-11.987C23.97 5.39 18.592.026 11.985.026L12.017 0z" />
                        </svg>
                    </span>
                    <input type="url" id="pinterest" wire:model.live="pinterest" class="flex-1 text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-r-md rounded-l-none shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11" placeholder="https://pinterest.com/yourusername" />
                </div>
                @error('pinterest')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
</div>
