@props(['review'])
@php
    $author = $review->user;
    $authorName = $author->name;
@endphp
<div class="bg-white border border-solid border-dark-blue/[0.1] rounded-lg p-7 sm:mb-[35px] mb-[18px]">
    <div class="flex sm:items-center items-start justify-between mb-[18px]">
        <div class="flex items-center gap-2">
            @if ($author->getMedia('logo')->count() > 0)
                <img class="border border-solid border-gray-1200 rounded-full w-9 h-9 flex items-center justify-center text-white text-xl font-normal bg-blue-1200" src="{{ $author->getFirstMediaUrl('logo', 'small') }}" alt="{{ $authorName }}" />
            @else
                <img class="border border-solid border-gray-1200 rounded-full w-9 h-9 flex items-center justify-center text-white text-xl font-normal bg-blue-1200" src="{{ $author->getFirstMediaUrl('avatar', 'small') }}" alt="{{ $authorName }}" />
            @endif
            <div>
                <h4 class="text-dark-blue font-bold text-base leading-none">{{ $authorName }}</h4>
                <div class="flex items-center gap-1.5 my-1.5">
                    <x-review.partials.review-average-star-yellow :rating="$review" :class="'w-3 h-3'" />
                </div>
            </div>

        </div>
        <p class="text-dark-blue/[0.7] text-xs font-normal leading-none sm:block hidden">
            {{ $review->created_at->format('F d, Y') }}
        </p>
        <p class="text-dark-blue/[0.7] text-xs font-normal leading-none sm:hidden block">
            {{ $review->created_at->format('M d, Y') }}
        </p>

    </div>
    <h4 class="text-dark-blue font-medium text-base leading-none mb-2">
        {{ $review->review_title }}
    </h4>
    <p class="text-dark-blue font-normal text-xs leading-normal">
        {{ $review->review_content }}
    </p>
</div>
