@props(['rating', 'class' => ''])

@php
    // Extract rating from the rating object or use as float
    $rating = is_object($rating) ? (float) ($rating->review_rating ?? 0) : (float) $rating;
    $rating = max(0, min(5, $rating)); // Clamp between 0 and 5

    // Calculate full stars and partial star
    $fullStars = floor($rating);
    $decimal = $rating - $fullStars;

    // Show partial star if there's any decimal value
$hasPartialStar = $decimal > 0;
$partialPercentage = $decimal * 100; // Convert to percentage for CSS

// Calculate empty stars
$emptyStars = 5 - $fullStars - ($hasPartialStar ? 1 : 0);

// Generate unique ID for gradient
$gradientId = 'star-gradient-yellow-' . uniqid();
@endphp

<ul class="flex gap-1.5 items-center">
    {{-- Full Stars --}}
    @for ($i = 0; $i < $fullStars; $i++)
        <li>
            <svg viewBox="0 0 18 18" class="{{ $class }}">
                <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="#F59E0B" />
            </svg>
        </li>
    @endfor

    {{-- Partial Star (if needed) --}}
    @if ($hasPartialStar)
        <li>
            <svg viewBox="0 0 18 18" class="{{ $class }}">
                <defs>
                    <linearGradient id="{{ $gradientId }}"
                        x1="0%"
                        y1="0%"
                        x2="100%"
                        y2="0%">
                        <stop offset="{{ $partialPercentage }}%" style="stop-color:#F59E0B;stop-opacity:1" />
                        <stop offset="{{ $partialPercentage }}%" style="stop-color:#D1D5DB;stop-opacity:1" />
                    </linearGradient>
                </defs>
                <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="url(#{{ $gradientId }})" />
            </svg>
        </li>
    @endif

    {{-- Empty Stars --}}
    @for ($i = 0; $i < $emptyStars; $i++)
        <li>
            <svg viewBox="0 0 18 18" class="{{ $class }}">
                <path d="M9 0L12.0593 5.52274L18 6.87539L13.95 11.6413L14.5623 18L9 15.4227L3.43769 18L4.05 11.6413L0 6.87539L5.94073 5.52274L9 0Z" fill="#D1D5DB" />
            </svg>
        </li>
    @endfor
</ul>
