@php
    use Illuminate\Support\Facades\Storage;

    $buttonClass = 'text-white font-medium flex items-center justify-center rounded-md gap-2 md:gap-3.5 w-full';

    if ($buttonsize === 'sm') {
        $buttonClass .= ' h-[36px] md:h-[40px] px-3 md:px-4 py-1 text-sm';
    } elseif ($buttonsize === 'lg') {
        $buttonClass .= ' h-[50px] md:h-[60px] px-6 md:px-8 py-2 md:py-3 text-base md:text-lg';
    } else {
        $buttonClass .= ' h-[45px] md:h-[51px] px-6 md:px-8 py-2 md:py-3 text-base md:text-[18px] font-medium leading-normal';
    }

    if ($buttoncolor === 'black') {
        $buttonClass .= ' bg-black !text-white hover:bg-black-1200 focus:ring-black-1200';
    } elseif ($buttoncolor === 'red') {
        $buttonClass .= ' bg-red-bg !text-white hover:bg-red-1200 focus:ring-red-1200';
    } elseif ($buttoncolor === 'white') {
        $buttonClass .= ' bg-white !text-black hover:bg-gray-100 focus:ring-gray-100';
    } else {
        $buttonClass .= ' bg-light-blue !text-white hover:bg-light-blue-1200 focus:ring-light-blue-1200';
    }

    $outlineClass = 'text-light-blue border border-solid border-light-blue font-medium flex items-center justify-center rounded-md gap-2 md:gap-3.5 w-full';
    if ($outlinebuttonsize === 'sm') {
        $outlineClass .= ' h-[36px] md:h-[40px] px-3 md:px-4 py-1 text-sm';
    } elseif ($outlinebuttonsize === 'lg') {
        $outlineClass .= ' h-[50px] md:h-[60px] px-6 md:px-8 text-base md:text-lg';
    } else {
        $outlineClass .= ' h-[45px] md:h-[51px] px-6 md:px-8 py-2 md:py-3 text-base md:text-[18px] font-medium leading-normal';
    }

    $containerClass = match ($template) {
        'ad_with_image' => 'esp-ads-wrap eps-quick-add flex flex-col md:flex-row gap-6 md:gap-8',
        'boxed' => 'esp-ads-wrap eps-adds eps-boxed-ads p-4 md:p-6',
        'ribbon' => 'esp-ads-wrap eps-adds eps-action-add relative',
        'compact_image' => 'esp-ads-wrap eps-adds-small flex flex-col md:flex-row gap-4 md:gap-6',
        default => 'esp-ads-wrap eps-adds',
    };
@endphp

<div class="{{ $containerClass }}">
    @if ($template === 'ribbon')
        <div class="absolute top-0 left-0 z-10 eps-tag">
            {{ $badgetitle }}
            <div class="tag-shape">
                <img src="{{ asset('themes/ep/' . $themeName . '/img/tag-shape.svg') }}" alt="" class="w-full h-auto" />
            </div>
        </div>
    @endif

    @if ($layout !== 'reversed')
        @if (($template === 'ad_with_image' || $template === 'compact_image') && !empty($image))
            <div class="flex-shrink-0 w-full image-holder md:w-auto">
                <img src="{{ Storage::url($image) }}" alt="{{ $title }}" class="rounded-[5px] w-full md:w-auto object-cover" />
            </div>
        @endif
    @endif

    @if ($template === 'compact_image')
        <div class="flex flex-col flex-grow gap-4 eps-adds-media md:flex-row md:gap-6">
            <div class="flex-grow text-inner">
                <h3 class="mb-2 text-lg font-semibold md:text-xl">{{ $title }}</h3>
                <p class="text-sm md:text-base">{{ $description }}</p>
            </div>
            <div class="add-text-right flex flex-col gap-3 md:min-w-[200px]">
                @if (!empty($buttonlabel))
                    <a href="{{ $buttonurl }}" target="{{ $buttontarget }}" class="{{ $buttonClass }}">
                        {{ $buttonlabel }}
                        <img src="{{ asset('themes/ep/' . $themeName . '/img/top-arrow-white.svg') }}" alt="" class="w-4 h-4" />
                    </a>
                @endif
                @if (!empty($bottominfo))
                    <p class="text-sm text-gray-600">{{ $bottominfo }}</p>
                @endif
            </div>
        </div>
    @else
        <div class="flex-grow text-box">
            @if (($template === 'ad_with_image' || $template === 'boxed') && !empty($badgetitle))
                <strong class="inline-block mb-3 text-sm md:text-base">{{ $badgetitle }}</strong>
            @endif

            <h2 class="mb-3 text-xl font-bold md:text-2xl">{{ $title }}</h2>
            <p class="mb-4 text-base">{{ $description }}</p>

            <ul class="flex flex-col md:flex-row items-stretch md:items-center gap-4 md:gap-6 mb-3.5">
                @if (!empty($buttonlabel))
                    <li class="flex-grow md:flex-grow-0">
                        <a href="{{ $buttonurl }}" target="{{ $buttontarget }}" class="{{ $buttonClass }}">
                            {{ $buttonlabel }}
                            <img src="{{ asset('themes/ep/' . $themeName . '/img/top-arrow-white.svg') }}" alt="" class="w-4 h-4" />
                        </a>
                    </li>
                @endif
                @if (($template === 'boxed' || $template === 'ribbon') && !empty($outlinebuttontext))
                    <li class="flex-grow md:flex-grow-0">
                        <a href="{{ $outlinebuttonurl }}" target="{{ $outlinebuttontarget }}" class="{{ $outlineClass }}">
                            {{ $outlinebuttontext }}
                            <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 md:w-4 md:h-4">
                                <path d="M1 11.5L11 1.5M11 1.5H1M11 1.5V11.5" stroke="#0172B1" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </a>
                    </li>
                @endif
            </ul>

            @if (!empty($bottominfo))
                <span class="text-sm text-gray-600 bottom-info">{{ $bottominfo }}</span>
            @endif
        </div>
    @endif

    @if ($layout === 'reversed')
        @if ($template === 'ad_with_image' && !empty($image))
            <div class="flex-shrink-0 w-full image-holder md:w-auto">
                <img src="{{ Storage::url($image) }}" alt="{{ $title }}" class="rounded-[5px] w-full md:w-auto object-cover" />
            </div>
        @endif
    @endif
</div>
