@php
    $buttonClass = 'inline-flex items-center rounded-md font-semibold text-sm !no-underline my-2 transition-all duration-200 relative overflow-hidden';
    $containerClass = '';
    $hoverClass = '';

    // Size classes
    if($size === 'sm') {
        $buttonClass .= ' px-2 py-1 text-xs';
    } elseif($size === 'lg') {
        $buttonClass .= ' px-6 py-3 text-base';
    } else {
        $buttonClass .= ' px-4 py-2 text-sm';
    }

    // Style and color classes with hover effects
    if($style === 'outline') {
        if($color === 'black') {
            $baseClass = ' border-2 border-black !text-black';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-black hover:!text-white',
                'fade' => 'hover:bg-black/10 hover:border-black/70',
                'slide' => 'before:absolute before:inset-0 before:bg-black before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-white before:-z-10',
                default => '',
            };
        } elseif($color === 'red') {
            $baseClass = ' border-2 border-red-bg !text-red-bg';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-red-bg hover:!text-white',
                'fade' => 'hover:bg-red-bg/10 hover:border-red-bg/70',
                'slide' => 'before:absolute before:inset-0 before:bg-red-bg before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-white before:-z-10',
                default => '',
            };
        } elseif($color === 'white') {
            $baseClass = ' border-2 border-white !text-white';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-white hover:!text-black',
                'fade' => 'hover:bg-white/20',
                'slide' => 'before:absolute before:inset-0 before:bg-white before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-black before:-z-10',
                default => '',
            };
        } else {
            $baseClass = ' border-2 border-light-blue !text-light-blue';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-light-blue hover:!text-white',
                'fade' => 'hover:bg-light-blue/10 hover:border-light-blue/70',
                'slide' => 'before:absolute before:inset-0 before:bg-light-blue before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-white before:-z-10',
                default => '',
            };
        }
    } else {
        if($color === 'black') {
            $baseClass = ' bg-black !text-white border-2 border-transparent';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-white hover:!text-black hover:border-black',
                'fade' => 'hover:bg-black/80',
                'slide' => 'before:absolute before:inset-0 before:bg-white before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-black before:-z-10 hover:border-black',
                default => '',
            };
        } elseif($color === 'red') {
            $baseClass = ' bg-red-bg !text-white border-2 border-transparent';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-white hover:!text-red-bg hover:border-red-bg',
                'fade' => 'hover:bg-red-bg/80',
                'slide' => 'before:absolute before:inset-0 before:bg-white before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-red-bg before:-z-10 hover:border-red-bg',
                default => '',
            };
        } elseif($color === 'white') {
            $baseClass = ' bg-white !text-black border-2 border-transparent';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-black hover:!text-white hover:border-white',
                'fade' => 'hover:bg-white/80',
                'slide' => 'before:absolute before:inset-0 before:bg-black before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-white before:-z-10 hover:border-white',
                default => '',
            };
        } else {
            $baseClass = ' bg-light-blue !text-white border-2 border-transparent';
            $hoverClass = match($hovereffect) {
                'reverse' => 'hover:bg-white hover:!text-light-blue hover:border-light-blue',
                'fade' => 'hover:bg-light-blue/80',
                'slide' => 'before:absolute before:inset-0 before:bg-white before:translate-y-full hover:before:translate-y-0 before:transition-transform before:duration-200 hover:!text-light-blue before:-z-10 hover:border-light-blue',
                default => '',
            };
        }
    }

    $buttonClass .= $baseClass . ' ' . $hoverClass;

    // Alignment classes
    if($align === 'center') {
        $containerClass = 'text-center';
    } elseif($align === 'right') {
        $containerClass = 'text-right';
    } else {
        $containerClass = 'text-left';
    }
@endphp
<div class="{{ $containerClass }}">
    <a href="{{ $url }}" target="{{ $target }}" class="{{ $buttonClass }}">
        <span class="relative">{{ $label }}</span>
    </a>
</div>
