@php
    use Illuminate\Support\Facades\Storage;
    $image_url = Storage::url($imageurl);
@endphp
<div class="flex items-center justify-center my-8" @if ($trackingid) data-tracking-id="{{ $trackingid }}"
        x-data="{ trackClick() { window.dispatchEvent(new CustomEvent('ad-click', { detail: { id: '{{ $trackingid }}' } })) } }" @endif>
    <a href="{{ $thumbnaillink }}" target="{{ $buttontarget }}" @if ($trackingid) @click="trackClick" @endif class="block w-full max-w-screen-xl mx-auto transition-opacity duration-200 hover:opacity-95">
        <picture>
            @if ($responsive)
                <source media="(min-width: 640px)" srcset="{{ $getImageUrl() }}" width="1200" height="510">
                <source media="(max-width: 639px)" srcset="{{ $getImageUrl() }}" width="800" height="340">
            @endif
            <img class="w-full rounded-lg shadow-lg" src="{{ $getImageUrl() }}" @if ($lazyload) loading="lazy" @endif alt="{{ $alttext }}" width="{{ $responsive ? '800' : '1200' }}" height="{{ $responsive ? '340' : '510' }}">
        </picture>
    </a>
</div>
