@php
    $containerClass = match($alignment) {
        'left' => 'text-left',
        'right' => 'text-right',
        default => 'text-center',
    };

    $imageClass = match($size) {
        'small' => 'w-1/4',
        'medium' => 'w-1/2',
        'large' => 'w-3/4',
        'full' => 'w-full',
        default => 'w-1/2',
    };

    $imageClass .= ' inline-block';
@endphp

<figure class="{{ $containerClass }} my-8">
    <img 
        src="{{ \Illuminate\Support\Facades\Storage::url($image) }}" 
        alt="{{ $alttext }}" 
        loading="lazy"
        class="{{ $imageClass }} rounded-lg shadow-lg"
    >
    @if($caption)
        <figcaption class="mt-3 text-sm text-gray-600 dark:text-gray-400">
            {{ $caption }}
        </figcaption>
    @endif
</figure> 