<div class="sticky-wrapper">
    <div x-ref="sentinel" class="sticky-sentinel"></div>
    <header
        x-data="{
            isSticky: false,
            observer: null,
            initObserver() {
                this.observer = new IntersectionObserver(([entry]) => {
                    this.isSticky = !entry.isIntersecting;
                }, { threshold: 0 });

                if (this.$refs.sentinel) {
                    this.observer.observe(this.$refs.sentinel);
                }
            }
        }"
        x-init="initObserver()"
        x-ref="header"
        class="sticky-header-actions fi-header flex flex-col sm:flex-row sm:items-center sm:justify-between"
        :class="{ 'is-sticky': isSticky }"
    >
        <!-- Title and Breadcrumbs -->
        <div 
            x-show="!isSticky" 
            x-transition.opacity 
            class="transition-opacity esp-header-title duration-300 flex-1"
        >
            <div class="fi-breadcrumbs mb-2 hidden sm:block">
                <x-filament::breadcrumbs :breadcrumbs="$this->getBreadcrumbs()" />
            </div>

            @if (filled($this->getHeading()))
                <h1 class="text-2xl font-bold tracking-tight">
                    {{ $this->getHeading() }}
                </h1>
            @endif
        </div>

        <!-- Actions -->
        <div class="flex shrink-0 esp-header-actions items-center gap-3 sm:mt-7">
            @foreach ($this->getHeaderActions() as $action)
                {{ $action }}
            @endforeach
        </div>
    </header>
</div>