<x-filament-panels::page>
    @if($showTokenAlert && $generatedToken)
        <div class="mb-6" x-data="{ copied: false }">
            <div class="bg-success-50 dark:bg-success-900/20 border border-success-200 dark:border-success-800 rounded-lg p-6">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="h-6 w-6 text-success-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div class="ml-3 flex-1">
                        <h3 class="text-lg font-semibold text-success-800 dark:text-success-200">
                            🎉 API Client Created & Token Generated!
                        </h3>
                        <p class="mt-2 text-sm text-success-700 dark:text-success-300">
                            Your API client has been created successfully and a default token has been generated. Please copy and store this token securely.
                        </p>
                    </div>
                </div>

                <div class="mt-6 space-y-4">
                    <!-- Token Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Token Name
                        </label>
                        <div class="p-3 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg">
                            <p class="text-sm font-mono text-gray-900 dark:text-gray-100">{{ $generatedTokenName }}</p>
                        </div>
                    </div>

                    <!-- Generated Token -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            API Token
                        </label>
                        <div class="relative">
                            <textarea
                                readonly
                                rows="3"
                                class="block w-full px-3 py-2 font-mono text-sm text-gray-900 dark:text-gray-100 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-success-500 dark:focus:ring-success-600 focus:border-success-500 dark:focus:border-success-600"
                                onclick="this.select();"
                                style="user-select: all;"
                            >{{ $generatedToken }}</textarea>
                            <button
                                type="button"
                                @click="
                                    navigator.clipboard.writeText('{{ $generatedToken }}');
                                    copied = true;
                                    setTimeout(() => copied = false, 2000);
                                "
                                class="absolute top-2 right-2 px-3 py-1.5 text-xs font-medium text-white bg-success-600 hover:bg-success-700 rounded-md transition-colors"
                            >
                                <span x-show="!copied">Copy</span>
                                <span x-show="copied" x-cloak>Copied!</span>
                            </button>
                        </div>
                        <p class="mt-2 text-xs text-gray-600 dark:text-gray-400">
                            Click to select all, then copy (Ctrl/Cmd + C), or use the Copy button
                        </p>
                    </div>

                    <!-- Warning Message -->
                    <div class="p-4 bg-warning-50 dark:bg-warning-900/20 border border-warning-200 dark:border-warning-800 rounded-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-warning-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h4 class="text-sm font-semibold text-warning-800 dark:text-warning-200">
                                    ⚠️ IMPORTANT: Save This Token Now!
                                </h4>
                                <div class="mt-2 text-sm text-warning-700 dark:text-warning-300">
                                    <p class="mb-2">For security reasons, this token will not be shown again. Make sure to:</p>
                                    <ul class="list-disc list-inside space-y-1">
                                        <li>Copy and store it in a secure location (e.g., password manager)</li>
                                        <li>Never commit it to version control</li>
                                        <li>Never share it via email or messaging</li>
                                        <li>Revoke it immediately if compromised</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{ $this->infolist }}
</x-filament-panels::page>
