@php
    $record = $getRecord();
@endphp

<div class="flex items-center gap-2">
    @if($record->published_at)
        <div class="relative group">
            <div class="flex items-center gap-1 cursor-pointer">
                <x-heroicon-m-calendar class="w-5 h-5 text-primary-600" />
            </div>
            <div class="absolute hidden group-hover:block z-50 bottom-full left-1/2 -translate-x-1/2 mb-1">
                <div class="bg-gray-900 text-white text-xs rounded py-1 px-2 whitespace-nowrap">
                    Published: {{ $record->published_at->format('M d, Y H:i') }}
                </div>
            </div>
        </div>
    @endif

    @if($record->expired_at)
        <div class="relative group">
            <div class="flex items-center gap-1 cursor-pointer">
                <x-heroicon-m-archive-box-x-mark class="w-5 h-5 text-warning-500" />
            </div>
            <div class="absolute hidden group-hover:block z-50 bottom-full left-1/2 -translate-x-1/2 mb-1">
                <div class="bg-gray-900 text-white text-xs rounded py-1 px-2 whitespace-nowrap">
                    Expires: {{ $record->expired_at->format('M d, Y H:i') }}
                </div>
            </div>
        </div>
    @endif
</div> 